#include "../lib/of1275.h"
#include "opic.h"

int
main()
{
  
  int i;
  opic_descriptor opic;

  opic_parse_args(&opic, 0);

  /* program up interrupt source zero */
  for (i = 0; i < opic.nr_inputs; i++) {
    opic.interrupt_source_configuration[i].vector_priority.reg = 
      htovl(level_triggered
	    | ((i & 1) ? positive_polarity : 0)
	    | ((i + 1) << 16) | (i + 1));
    opic.interrupt_source_configuration[i].destination.reg = htovl(-1);
  }

  /* enable interrupts for cpu 0 only */
  opic.per_processor[0].current_task_priority.reg = htovl(0);


  /* Stimulate each interrupt independantly - should see each
     interrupt come and then go */

  for (i = 0; i < opic.nr_inputs; i++) {

    /* pend the interrupt */
    opic.input[i] = htonl((i & 1));

    /* check pending */
    if (htonl(opic.output[0]) == 0) {
      write_string("no pending interrupt ");
      write_int(i);
      write_line();
      exit (1);
    }

    /* check delivered */
    if (vtohl(opic.per_processor[0].interrupt_acknowledge.reg) != i + 1) {
      write_string("bad ack for ");
      write_int(i);
      write_line();
      exit (1);
    }

    /* clear the source */
    opic.input[i] = htonl(!(i & 1));

    /* check pending cleared */
    if (htonl(opic.output[0]) != 0) {
      write_string("pending interrupt ");
      write_int(i);
      write_string(" not cleared");
      write_line();
      exit (1);
    }

    /* check the ack also cleared */
    if (vtohl(opic.per_processor[0].interrupt_acknowledge.reg) != 255) {
      write_string("bad spurious vector for ");
      write_int(i);
      write_line();
      exit (1);
    }


    /* end this interrupt */
    opic.per_processor[0].end_of_interrupt.reg = 0;

  }

  exit (0);
}
