/* Print out the current value of the NVRAM */

#include "../lib/oea_dev.h"

enum {
  max_addr = 16,
};

static unsigned
sequence(unsigned previous)
{
  if (previous == 0)
    return 0xFFFFFFFB;
  else
    return previous * 47 / 3;
}

int
main(int argc, char **argv)
{
  int i;
  int nr_addr;
  unsigned data;
  unsigned addr[max_addr];
  unsigned size[max_addr];
  
  /* check the arguments */
  if (argc < 3
      || ((argc - 1) % 2) != 0
      || (argc - 1) > max_addr) {
    write_string("Usage: phb <addr> <size> ... (max ");
    write_int(max_addr);
    write_string(" pairs)");
    write_line();
    exit (1);
  }

  /* get the list of addresses */
  for (nr_addr = 0; nr_addr < (argc - 1) / 2; nr_addr ++) {
    const char *addrp = argv[nr_addr * 2 + 1];
    const char *sizep = argv[nr_addr * 2 + 2];
    addr[nr_addr] = strtoul(addrp, 0, 0);
    size[nr_addr] = strtoul(sizep, 0, 0);
    switch (size[nr_addr]) {
    case 1:
    case 2:
    case 4:
      break;
    default:
      write_string("Invalid size ");
      write_int(size[nr_addr]);
      write_line();
      break;
    }
  }
  
  /* write something into each address */
  data = 0;
  for (i = 0; i < nr_addr; i++) {
    data = sequence(data);
    write_string("mem[0x");
    write_hex(addr[i]);
    write_string(":");
    write_int(size[i]);
    write_string("] = 0x");
    switch (size[i]) {
    case 1:
      write_hex(data & 0xff);
      write_line();
      *(unsigned char*)addr[i] = data;
      break;
    case 2:
      write_hex(data & 0xffff);
      write_line();
      *(unsigned short*)addr[i] = data;
      break;
    case 4:
      write_hex(data & 0xffffffff);
      write_line();
      *(unsigned int*)addr[i] = data;
      break;
    }
  }

  /* verify each address */
  data = 0;
  for (i = 0; i < nr_addr; i++) {
    unsigned correct;
    unsigned sample;
    data = sequence(data);
    switch (size[i]) {
    case 1:
      sample = *(unsigned char*)addr[i];
      correct = data & 0xff;
      break;
    case 2:
      sample = *(unsigned short*)addr[i];
      correct = data & 0xffff;
      break;
    case 4:
      sample = *(unsigned int*)addr[i];
      correct = data & 0xffffffff;
      break;
    }
    if (sample != correct) {
      write_string("Error - mem[0x");
      write_hex(addr[i]);
      write_string(":");
      write_int(size[i]);
      write_string("] was 0x");
      write_hex(sample);
      write_line();
    }
  }


  exit(0);
}
