From highland!wabbit.cc.uow.edu.au!metro!news.cs.su.oz.au!harbinger.cc.monash.edu.au!msuinfo!uwm.edu!cs.utexas.edu!usc!elroy.jpl.nasa.gov!lll-winken.llnl.gov!apple.com!usenet Tue Jun  7 14:15:32 EST 1994
Status: O

Article 28881 of comp.sys.powerpc:
Path: highland!wabbit.cc.uow.edu.au!metro!news.cs.su.oz.au!harbinger.cc.monash.edu.au!msuinfo!uwm.edu!cs.utexas.edu!usc!elroy.jpl.nasa.gov!lll-winken.llnl.gov!apple.com!usenet
>From: tim@apple.com (Tim Olson)
Newsgroups: comp.sys.powerpc
Subject: Re: PPC system code
Date: 6 Jun 1994 02:40:12 GMT
Organization: Apple Computer, Inc., Cupertino, California
Lines: 193
Message-ID: <2su2ac$cf8@apple.com>
References: <valentinCqx255.8vx@netcom.com>
Reply-To: tim@apple.com
NNTP-Posting-Host: 129.38.252.135

Valentin Pepelea writes:
| I'm looking for working examples of system code, such as exception handling,
| interrupt stubs that set up the environment to transfer control to an
| interrupt service routine written in C, and context switching code. Is there
| an ftp site where I can fetch examples?

Here are some working examples I've written:

--- dsi interrupt handler ---
;#===========================================================================#
;#			 Data Storage Interrupt				     #
;#===========================================================================#
dsi:
	mtspr	sprg1, r1		;# save r1 temporarily
	mfspr	r1, sprg0		;# get pointer to process entry
	stw	r0, REG_GPR0*4(r1)	;# save r0
	mflr	r0
	stw	r0, REG_LR*4(r1)	;# save lr

	bl	.save			;# save the rest of the state
	nop

	lwz	r3, T.proc_ptr(rtoc)	;# get pointer to process entry
	lwz	r3, 0(r3)
	lwz	r4, REG_DSISR*4(r3)	;# get DSISR register
	andis.	r5, r4, 1<(31-0-16)	;# direct-store error?
	bne	.sigbus
	andis.	r5, r4, 1<(31-1-16)	;# page fault?
	bne	.data_page_fault
	andis.	r5, r4, 1<(31-4-16)	;# protection fault?
	bne	.sigsegv
	andis.	r5, r4, 1<(31-5-16)	;# T=1 cache op or lwarx/stwcx wt
	bne	.sigbus
	andis.	r5, r4, 1<(31-9-16)	;# DABR match
	bne	.sigtrap
	andis.	r5, r4, 1<(31-11-16)	;# EAR?
	bne	.sigill

	stwu	sp, -64(sp)		;# allocate 64 registers
	lwz	r3, T.dsi_string(rtoc)	;# get panic string
	li	r4, NO_NUM-1
	addi	r4, r4, 1
	bl	.panic
	nop
	b	.restart


--- sigsegv stub interface to C code ---
;#===========================================================================#
;#				sigsegv					     #
;#===========================================================================#
sigsegv:
	stwu	sp, -64(sp)		;# allocate 64 bytes
	lwz	r3, T.proc_ptr(rtoc)	;# 1st parameter to C routine
	lwz	r3, 0(r3)		;# get proc_ptr
	li	r4, SIGSEGV		;# second parameter
	bl	.cause_sig
	nop

	b	.restart


--- state save for context switch ---
;#===========================================================================#
;#				  save					     #
;#===========================================================================#
save:

;# when save is called, r0 and lr have been saved and r1 is in sprg1.
;# A pointer to the process entry is in r1.

;# set up the MSR
	li	r0, (1<(31-MSR_ME))
	mtmsr	r0
	isync

	stmw	r2, (REG_GPR0+2)*4(r1)	;# save rest of gpr's
	mfspr	r0, sprg1
	stw	r0, (REG_GPR0+1)*4(r1)	;# save r1

;# save system special registers
	mfdsisr	r0
	stw	r0, REG_DSISR*4(r1)	;# save dsisr
	mfdar	r0
	stw	r0, REG_DAR*4(r1)	;# save dar
	mfsrr0	r0
	stw	r0, REG_SRR0*4(r1)	;# save srr0
	mfsrr1	r0
	stw	r0, REG_SRR1*4(r1)	;# save srr1

;# save user special registers (lr already saved)
	mfcr	r0
	stw	r0, REG_CR*4(r1)	;# save cr
	mfxer	r0
	stw	r0, REG_XER*4(r1)	;# save xer
	mfctr	r0
	stw	r0, REG_CTR*4(r1)	;# save ctr

;# clear p_fsave flag to indicate "slow" save
	li	r0, 0
	stw	r0, NR_REGS*4(r1)

;# set up kernel TOC
	mfspr	rtoc, sprg2

;# set up the stack pointer
	lwz	sp, T.k_stack(rtoc)
	lwz	sp, 0(sp)
	addi	sp, sp, TASK_STACK_BYTES

	blr

--- state restore for context switch ---
;#===========================================================================#
;#			        restart					     #
;#===========================================================================#
restart:

;# disable interrupts
	mfmsr	r0
	li	r4, 1<(31-MSR_EE-1)
	slwi	r4, r4, 1
	andc	r0, r0, r4
	mtmsr	r0
	isync

;# set up proc_ptr in sprg0
	lwz	r1, T.proc_ptr(rtoc)
	lwz	r1, 0(r1)
	mtspr	sprg0, r1

	lwz	r13, T.cur_proc(rtoc)	;# is current process IDLE?
	lwz	r13, 0(r13)
	cmpwi	cr0, r13, IDLE
	beq	.idle

;# set up segment registers for new process
;# segments: seg1 = text, seg2 = data, seg3 = stack.
;# seg0 is not used, to help catch NULL pointer dereferences.
;# The segments use the process number in the upper bits of the VSID;
;# the lower 4 bits of the VSID are set equal to the segment number.
	cmpwi	cr0, r13, 0		;# restart a task or process?
	mfcr	r0			;# negative result is bit 0
	srawi	r0, r0, 31		;# mask (= -1 for task, 0 for process)
	not	r0, r0			;# mask (= 0 for task, -1 for process)
	andi.	r13, r13, 0xff		;# process # (0 - 255)
	addi	r13, r13, 1
	and	r13, r13, r0		;# process#+1, or 0 for task
	slwi	r13, r13, 4		;# adjust for seg# offset
	oris	r13, r13, 1<(31-2-16)	;# set Ku bit
	addi	r13, r13, 1
	mtsr	1, r13			;# set up segment 1
	addi	r13, r13, 1
	mtsr	2, r13			;# set up segment 2
	addi	r13, r13, 1
	mtsr	3, r13			;# set up segment 3

;# check for "fast" or "slow" restore
	lwz	r3, (NR_REGS*4)(r1)
	cmpwi	cr0, r3, 0
	bne	.frestart
	
;# restore user special registers
	lwz	r0, REG_CR*4(r1)
	mtcrf	0xff, r0
	lwz	r0, REG_XER*4(r1)	;# restore xer
	mtxer	r0
	lwz	r0, REG_LR*4(r1)	;# restore lr
	mtlr	r0
	lwz	r0, REG_CTR*4(r1)	;# restore ctr
	mtctr	r0

;# restore system special registers
	lwz	r0, REG_DSISR*4(r1)	;# restore dsisr
	mtdsisr	r0
	lwz	r0, REG_DAR*4(r1)	;# restore dar
	mtdar	r0
	lwz	r0, REG_SRR0*4(r1)	;# restore srr0
	mtsrr0	r0
	lwz	r0, REG_SRR1*4(r1)	;# restore srr1
	mtsrr1	r0

;# restore gpr's
	lmw	r2, (REG_GPR0+2)*4(r1)	;# restore r2 - r31
	lwz	r0, (REG_GPR0)*4(r1)	;# restore r0
	lwz	r1, (REG_GPR0+1)*4(r1)	;# restore r1

	rfi

--
	-- Tim Olson
	Apple Computer Inc. / Somerset
	


