/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XShapeQueryVersion()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/shape.h>
extern Display *display ;



#define T_XShapeQueryVersion	1
char    *TestName = "XShapeQueryVersion";



static int 	StatusReturn;

int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Window  window;
int   value_good;
int   major_version;
int   minor_version;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XShapeQueryVersion-1.(A)");
	report_assertion("A call to Status XShapeQueryVersion(display, major_version,");
	report_assertion("minor_version) shall return a non-zero value and set the");
	report_assertion("major and minor version numbers of the extension supported");
	report_assertion("by the display.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	tet_infoline("PREP: Open display and create window");
	window = (Window) avs_xext_init();
	tet_infoline("TEST: XShapeQueryVersion");
	value_good = XShapeQueryVersion(display,
		     &major_version, &minor_version) ;
	tet_infoline("TEST: Non zero value is returned");
	if (value_good <=0 ) {
		sprintf(ebuf, "ERROR: Expected non zero, returned %d", value_good);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TESTING: major_version is set to valid value");
	if (major_version <= 0) {
		sprintf(ebuf, "ERROR: Expected non zero returned %d", major_version);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TESTING: minor_version is set to valid value");
	if (minor_version < 0) {
		sprintf(ebuf, "ERROR: Expected positive number returned %d", minor_version);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}

	LKROF(pid2, AVSXTTIMEOUT);
        tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.3652 */
/* End of included file Mdefcode.tmc.3652 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
