/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XSelectInput(display, w, event_mask)
 *   Display *display;
 *   Window w;
 *   long event_mask;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XSelectInput	1
char    *TestName = "XSelectInput";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XSelectInput function
 */
static Display *display;
static Window w;
static long event_mask;


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = 0;
	event_mask = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	w = ErrdefWindow;
}

static void t001(){

Display *client1;
Display *client2;
XEvent	event;
int	n;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XSelectInput-1.(A)");
	report_assertion("A call to XSelectInput requests that the X server report");
	report_assertion("the events for window w matching event_mask.");

	report_strategy("Create client1.");
	report_strategy("Create window with client1.");
	report_strategy("Select no events with client1 on this window.");
	report_strategy("Create client2.");
	report_strategy("Select MapNotify events with client2 on this window.");
	report_strategy("Map window.");
	report_strategy("XSync(.., False) on both clients to ensure generated events have come in.");
	report_strategy("Verify that client1 received no events.");
	report_strategy("Verify that client2 received a single MapNotify event for this window.");
	report_strategy("Verify that client2 received no other events.");

	tpstartup();
	setargs();
/* Create client1. */
	client1 = opendisplay();
	if (client1 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Create window with client1. */
	w = mkwin(client1, (XVisualInfo *) NULL, (struct area *) NULL, False);
/* Select no events with client1 on this window. */
	BASIC_STARTCALL(client1);
	XSelectInput(client1, w, NoEventMask);
	BASIC_ENDCALL(client1, Success);
/* Create client2. */
	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Select MapNotify events with client2 on this window. */
	BASIC_STARTCALL(client2);
	XSelectInput(client2, w, StructureNotifyMask);
	BASIC_ENDCALL(client2, Success);
/* Map window. */
	XSync(client1, True);
	XSync(client2, True);
	XMapWindow(client1, w);
/* XSync(.., False) on both clients to ensure generated events have come in. */
	XSync(client1, False);
	XSync(client2, False);
	trace("Mapping window with StructureNotifyMask selected, expecting MapNotify.");
/* Verify that client1 received no events. */
	if ((n=XPending(client1)) > 0) {
		XNextEvent(client1, &event);
		report("%d unexpected event%s (first %s) %s delivered to client1.",
			n, (n==1)?"":"s", eventname(event.type), (n==1)?"was":"were");
		FAIL;
	}
	else
		CHECK;
/* Verify that client2 received a single MapNotify event for this window. */
	if (!XCheckTypedWindowEvent(client2, w, MapNotify, &event)) {
		report("Selected event (MapNotify) was not delivered.");
		FAIL;
	}
	else
		CHECK;
/* Verify that client2 received no other events. */
	if ((n=XPending(client2)) > 0) {
		XNextEvent(client2, &event);
		report("%d unexpected event%s (first %s) %s delivered to client2.",
			n, (n==1)?"":"s", eventname(event.type), (n==1)?"was":"were");
		FAIL;
	}
	else
		CHECK;

	CHECKPASS(5);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XSetWindowAttributes setattrs;
XWindowAttributes attrs;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XSelectInput-2.(A)");
	report_assertion("A call to XSelectInput overrides the event mask attribute");
	report_assertion("set during any previous call to XSelectInput,");
	report_assertion("XChangeWindowAttributes, or XCreateWindow.");

	report_strategy("Create window with no events selected.");
	report_strategy("Call XGetWindowAttributes to get event mask for this window.");
	report_strategy("Verify event mask is as expected.");
	report_strategy("Call XSelectInput to change event mask to StructureNotifyMask.");
	report_strategy("Call XGetWindowAttributes to get new event mask for this window.");
	report_strategy("Verify event mask changed as expected.");
	report_strategy("Call XChangeWindowAttributes to change event mask to NoEventMask.");
	report_strategy("Call XGetWindowAttributes to get event mask for this window.");
	report_strategy("Verify event mask is as expected.");
	report_strategy("Call XSelectInput to change event mask to ALLEVENTS.");
	report_strategy("Call XGetWindowAttributes to get new event mask for this window.");
	report_strategy("Verify event mask changed as expected.");
	report_strategy("Call XSelectInput to change event mask to StructureNotifyMask.");
	report_strategy("Call XGetWindowAttributes to get new event mask for this window.");
	report_strategy("Verify event mask changed as expected.");

	tpstartup();
	setargs();
/* Create window with no events selected. */
	w = mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, False);
/* Call XGetWindowAttributes to get event mask for this window. */
	if (!XGetWindowAttributes(display, w, &attrs)) {
		delete("A call to XGetWindowAttributes failed.");
		return;
	}
	else
		CHECK;
/* Verify event mask is as expected. */
	if (attrs.your_event_mask != NoEventMask) {
		delete("Unexpected event mask value.");
		return;
	}
	else
		CHECK;
/* Call XSelectInput to change event mask to StructureNotifyMask. */
	event_mask = StructureNotifyMask;
	startcall(display);
	if (isdeleted())
		return;
	XSelectInput(display, w, event_mask);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
/* Call XGetWindowAttributes to get new event mask for this window. */
	if (!XGetWindowAttributes(display, w, &attrs)) {
		delete("A call to XGetWindowAttributes failed.");
		return;
	}
	else
		CHECK;
/* Verify event mask changed as expected. */
	if (attrs.your_event_mask != StructureNotifyMask) {
		report("Event mask incorrect first call.");
		FAIL;
	}
	else
		CHECK;
/* Call XChangeWindowAttributes to change event mask to NoEventMask. */
	setattrs.event_mask = NoEventMask;
	XChangeWindowAttributes(display, w, CWEventMask, &setattrs);
/* Call XGetWindowAttributes to get event mask for this window. */
	if (!XGetWindowAttributes(display, w, &attrs)) {
		delete("A call to XGetWindowAttributes failed.");
		return;
	}
	else
		CHECK;
/* Verify event mask is as expected. */
	if (attrs.your_event_mask != NoEventMask) {
		delete("Unexpected (non-empty) event mask value after XChangeWindowAttributes.");
		return;
	}
	else
		CHECK;
/* Call XSelectInput to change event mask to ALLEVENTS. */
	event_mask = ALLEVENTS;
	startcall(display);
	if (isdeleted())
		return;
	XSelectInput(display, w, event_mask);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
/* Call XGetWindowAttributes to get new event mask for this window. */
	if (!XGetWindowAttributes(display, w, &attrs)) {
		delete("A call to XGetWindowAttributes failed.");
		return;
	}
	else
		CHECK;
/* Verify event mask changed as expected. */
	if (attrs.your_event_mask != ALLEVENTS) {
		report("Event mask incorrect after second call.");
		FAIL;
	}
	else
		CHECK;
/* Call XSelectInput to change event mask to StructureNotifyMask. */
	event_mask = StructureNotifyMask;
	startcall(display);
	if (isdeleted())
		return;
	XSelectInput(display, w, event_mask);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
/* Call XGetWindowAttributes to get new event mask for this window. */
	if (!XGetWindowAttributes(display, w, &attrs)) {
		delete("A call to XGetWindowAttributes failed.");
		return;
	}
	else
		CHECK;
/* Verify event mask changed as expected. */
	if (attrs.your_event_mask != StructureNotifyMask) {
		report("Event mask incorrect after third call.");
		FAIL;
	}
	else
		CHECK;

	CHECKPASS(10);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Display *client1;
Display *client2;
XWindowAttributes attrs;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XSelectInput-3.(A)");
	report_assertion("A call to XSelectInput does not change the event mask");
	report_assertion("attribute for other clients.");

	report_strategy("Create client1.");
	report_strategy("Create window with client1.");
	report_strategy("Select NoEventMask events with client1 on this window.");
	report_strategy("Call XGetWindowAttributes to get event mask for client1 for window.");
	report_strategy("Verify event mask is as expected.");
	report_strategy("Create client2.");
	report_strategy("Select ALLEVENTS events with client2 on this window.");
	report_strategy("Call XGetWindowAttributes to get event mask for client2 for window.");
	report_strategy("Verify event mask is as expected.");
	report_strategy("Call XGetWindowAttributes to get event mask for client1 for window.");
	report_strategy("Verify event mask has not changed.");
	report_strategy("Select KeyPressMask events with client1 on this window.");
	report_strategy("Call XGetWindowAttributes to get event mask for client1 for window.");
	report_strategy("Verify event mask is as expected.");
	report_strategy("Call XGetWindowAttributes to get event mask for client2 for window.");
	report_strategy("Verify event mask has not changed.");

	tpstartup();
	setargs();
/* Create client1. */
	client1 = opendisplay();
	if (client1 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Create window with client1. */
	w = mkwin(client1, (XVisualInfo *) NULL, (struct area *) NULL, False);
/* Select NoEventMask events with client1 on this window. */
	BASIC_STARTCALL(client1);
	XSelectInput(client1, w, NoEventMask);
	BASIC_ENDCALL(client1, Success);
/* Call XGetWindowAttributes to get event mask for client1 for window. */
	if (!XGetWindowAttributes(client1, w, &attrs)) {
		delete("A call to XGetWindowAttributes failed.");
		return;
	}
	else
		CHECK;
/* Verify event mask is as expected. */
	if (attrs.your_event_mask != NoEventMask) {
		delete("Unexpected event mask value.");
		return;
	}
	else
		CHECK;
/* Create client2. */
	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Select ALLEVENTS events with client2 on this window. */
	BASIC_STARTCALL(client2);
	XSelectInput(client2, w, ALLEVENTS);
	BASIC_ENDCALL(client2, Success);
/* Call XGetWindowAttributes to get event mask for client2 for window. */
	if (!XGetWindowAttributes(client2, w, &attrs)) {
		delete("A call to XGetWindowAttributes failed.");
		return;
	}
	else
		CHECK;
/* Verify event mask is as expected. */
	if (attrs.your_event_mask != ALLEVENTS) {
		delete("Unexpected event mask value.");
		return;
	}
	else
		CHECK;
/* Call XGetWindowAttributes to get event mask for client1 for window. */
	if (!XGetWindowAttributes(client1, w, &attrs)) {
		delete("A call to XGetWindowAttributes failed.");
		return;
	}
	else
		CHECK;
/* Verify event mask has not changed. */
	if (attrs.your_event_mask != NoEventMask) {
		report("Event mask incorrect.");
		FAIL;
	}
	else
		CHECK;
/* Select KeyPressMask events with client1 on this window. */
	BASIC_STARTCALL(client1);
	XSelectInput(client1, w, KeyPressMask);
	BASIC_ENDCALL(client1, Success);
/* Call XGetWindowAttributes to get event mask for client1 for window. */
	if (!XGetWindowAttributes(client1, w, &attrs)) {
		delete("A call to XGetWindowAttributes failed.");
		return;
	}
	else
		CHECK;
/* Verify event mask is as expected. */
	if (attrs.your_event_mask != KeyPressMask) {
		delete("Unexpected event mask value.");
		return;
	}
	else
		CHECK;
/* Call XGetWindowAttributes to get event mask for client2 for window. */
	if (!XGetWindowAttributes(client2, w, &attrs)) {
		delete("A call to XGetWindowAttributes failed.");
		return;
	}
	else
		CHECK;
/* Verify event mask has not changed. */
	if (attrs.your_event_mask != ALLEVENTS) {
		report("Event mask incorrect.");
		FAIL;
	}
	else
		CHECK;

	CHECKPASS(12);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Display *client1;
Display *client2;
XEvent	event;
int	n;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XSelectInput-4.(A)");
	report_assertion("When multiple clients make a call to XSelectInput");
	report_assertion("requesting the same event on the same window and that window");
	report_assertion("is the event window for the requested event, then the event");
	report_assertion("is reported to each client.");

	report_strategy("Create client1.");
	report_strategy("Create window with client1.");
	report_strategy("Select MapNotify events with client1 on this window.");
	report_strategy("Create client2.");
	report_strategy("Select MapNotify events with client2 on this window.");
	report_strategy("Map window.");
	report_strategy("XSync(.., False) on both clients to ensure generated events have come in.");
	report_strategy("Verify that client1 received a single MapNotify event for this window.");
	report_strategy("Verify that client1 received no other events.");
	report_strategy("Verify that client2 received a single MapNotify event for this window.");
	report_strategy("Verify that client2 received no other events.");

	tpstartup();
	setargs();
/* Create client1. */
	client1 = opendisplay();
	if (client1 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Create window with client1. */
	w = mkwin(client1, (XVisualInfo *) NULL, (struct area *) NULL, False);
/* Select MapNotify events with client1 on this window. */
	BASIC_STARTCALL(client1);
	XSelectInput(client1, w, StructureNotifyMask);
	BASIC_ENDCALL(client1, Success);
/* Create client2. */
	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Select MapNotify events with client2 on this window. */
	BASIC_STARTCALL(client2);
	XSelectInput(client2, w, StructureNotifyMask);
	BASIC_ENDCALL(client2, Success);
/* Map window. */
	XSync(client1, True);
	XSync(client2, True);
	XMapWindow(client1, w);
/* XSync(.., False) on both clients to ensure generated events have come in. */
	XSync(client1, False);
	XSync(client2, False);
	trace("Mapping window with StructureNotifyMask selected, expecting MapNotify.");
/* Verify that client1 received a single MapNotify event for this window. */
	if (!XCheckTypedWindowEvent(client1, w, MapNotify, &event)) {
		report("Selected event was not delivered to client1.");
		FAIL;
	}
	else
		CHECK;
/* Verify that client1 received no other events. */
	if ((n=XPending(client1)) > 0) {
		XNextEvent(client1, &event);
		report("%d unexpected event%s (first %s) %s delivered to client1.",
			n, (n==1)?"":"s", eventname(event.type), (n==1)?"was":"were");
		FAIL;
	}
	else
		CHECK;
/* Verify that client2 received a single MapNotify event for this window. */
	if (!XCheckTypedWindowEvent(client2, w, MapNotify, &event)) {
		report("Selected event was not delivered to client2.");
		FAIL;
	}
	else
		CHECK;
/* Verify that client2 received no other events. */
	if ((n=XPending(client2)) > 0) {
		XNextEvent(client2, &event);
		report("%d unexpected event%s (first %s) %s delivered to client2.",
			n, (n==1)?"":"s", eventname(event.type), (n==1)?"was":"were");
		FAIL;
	}
	else
		CHECK;

	CHECKPASS(6);
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

Display *client1;
Display *client2;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XSelectInput-5.(A)");
	report_assertion("When another client has selected with an event mask");
	report_assertion("SubstructureRedirectMask, then on a call to XSelectInput");
	report_assertion("with SubstructureRedirectMask bits set in event_mask a");
	report_assertion("BadAccess error occurs.");

	report_strategy("Create client1.");
	report_strategy("Create window with client1.");
	report_strategy("Select SubstructureRedirectMask event mask with client1 on this window.");
	report_strategy("Create client2.");
	report_strategy("Select SubstructureRedirectMask event mask with client2 on this window.");
	report_strategy("Verify that a BadAccess error was generated.");

	tpstartup();
	setargs();
/* Create client1. */
	client1 = opendisplay();
	if (client1 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Create window with client1. */
	w = mkwin(client1, (XVisualInfo *) NULL, (struct area *) NULL, False);
/* Select SubstructureRedirectMask event mask with client1 on this window. */
	BASIC_STARTCALL(client1);
	XSelectInput(client1, w, SubstructureRedirectMask);
	BASIC_ENDCALL(client1, Success);
/* Create client2. */
	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Select SubstructureRedirectMask event mask with client2 on this window. */
	BASIC_STARTCALL(client2);
	XSelectInput(client2, w, SubstructureRedirectMask);
	BASIC_ENDCALL(client2, BadAccess);
/* Verify that a BadAccess error was generated. */
	if (geterr() != BadAccess) {
		report("A call to XSelectInput did not generate BadAccess error");
		FAIL;
	}
	else
		CHECK;

	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

Display *client1;
Display *client2;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XSelectInput-6.(A)");
	report_assertion("When another client has selected with an event mask");
	report_assertion("ResizeRedirectMask, then on a call to XSelectInput with");
	report_assertion("ResizeRedirectMask bits set in event_mask a BadAccess error");
	report_assertion("occurs.");

	report_strategy("Create client1.");
	report_strategy("Create window with client1.");
	report_strategy("Select ResizeRedirectMask event mask with client1 on this window.");
	report_strategy("Create client2.");
	report_strategy("Select ResizeRedirectMask event mask with client2 on this window.");
	report_strategy("Verify that a BadAccess error was generated.");

	tpstartup();
	setargs();
/* Create client1. */
	client1 = opendisplay();
	if (client1 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Create window with client1. */
	w = mkwin(client1, (XVisualInfo *) NULL, (struct area *) NULL, False);
/* Select ResizeRedirectMask event mask with client1 on this window. */
	BASIC_STARTCALL(client1);
	XSelectInput(client1, w, ResizeRedirectMask);
	BASIC_ENDCALL(client1, Success);
/* Create client2. */
	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Select ResizeRedirectMask event mask with client2 on this window. */
	BASIC_STARTCALL(client2);
	XSelectInput(client2, w, ResizeRedirectMask);
	BASIC_ENDCALL(client2, BadAccess);
/* Verify that a BadAccess error was generated. */
	if (geterr() != BadAccess) {
		report("A call to XSelectInput did not generate BadAccess error");
		FAIL;
	}
	else
		CHECK;

	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

Display *client1;
Display *client2;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XSelectInput-7.(A)");
	report_assertion("When another client has selected with an event mask");
	report_assertion("ButtonPressMask, then on a call to XSelectInput with");
	report_assertion("ButtonPressMask bits set in event_mask a BadAccess error");
	report_assertion("occurs.");

	report_strategy("Create client1.");
	report_strategy("Create window with client1.");
	report_strategy("Select ButtonPressMask event mask with client1 on this window.");
	report_strategy("Create client2.");
	report_strategy("Select ButtonPressMask event mask with client2 on this window.");
	report_strategy("Verify that a BadAccess error was generated.");

	tpstartup();
	setargs();
/* Create client1. */
	client1 = opendisplay();
	if (client1 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Create window with client1. */
	w = mkwin(client1, (XVisualInfo *) NULL, (struct area *) NULL, False);
/* Select ButtonPressMask event mask with client1 on this window. */
	BASIC_STARTCALL(client1);
	XSelectInput(client1, w, ButtonPressMask);
	BASIC_ENDCALL(client1, Success);
/* Create client2. */
	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Select ButtonPressMask event mask with client2 on this window. */
	BASIC_STARTCALL(client2);
	XSelectInput(client2, w, ButtonPressMask);
	BASIC_ENDCALL(client2, BadAccess);
/* Verify that a BadAccess error was generated. */
	if (geterr() != BadAccess) {
		report("A call to XSelectInput did not generate BadAccess error");
		FAIL;
	}
	else
		CHECK;

	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t008(){

int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XSelectInput-8.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XSelectInput(display, w, event_mask);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
