/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) 2003 The Open Group
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XcmsAllocColor()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <locale.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/Xresource.h>
#include <X11/Xproto.h>
#include <X11/Xcms.h>
#include <xtestlib.h>
#include <tet_api.h>
#include <r5structs.h>
#include <r5decl.h>
/*error messages created here*/
char	ebuf[4096];

#define T_XcmsAllocColor	1
char    *TestName = "XcmsAllocColor";



#include "xtest.h"

Bool  writeable_colormaps = 1;
Display	   *display_good;
Visual     *visual_good ;
XcmsCCC    ccc_good ;
Colormap   colormap_good, colormap_return ;
XcmsColor  cmsColorSpec ;
XcmsColor  color_in_out ;
XcmsColorFormat format_good ;
int        screen_good ;
int        depth_good ;
int x_init, y_init, h_init, w_init;
XColor goodColorSpec;
char tmpbuf[255];

void
svccmsAllocColor(display, colormap, color, format)
Display              *display ;
Colormap             colormap ;
XcmsColor            color ;
XcmsColorFormat      format ;
{
extern int  errcnt;
extern int  errflg;
extern int  chkflg;
extern int  signal_status();
extern int  unexp_err();

char fmtstr[256], *call_string;
union msglst fmt_lst[1];        
int tmpRGB;

int     ss_status,			  /* save stat return status */	
	stat_status,			  /* check stat return status */
	cleanup_status;

Status           svc_ret_value;


	/******
	* Turn on buffering and buffer parameter information
	* in case an error occurs
	******/
	regr_args.l_flags.bufrout = 1;

	(void)strcpy(fmtstr, "*********************\n");
	message(fmtstr, fmt_lst, 0);
	(void)strcpy(fmtstr, "An error occurred during a call to %s\n\n");
	fmt_lst[0].typ_str = TestName;
	message(fmtstr, fmt_lst, 1);


	call_string = "svc_ret_value = XcmsAllocColor(";

	(void)strcpy(fmtstr, "The routine call looked like this - \n    %s\n");
	fmt_lst[0].typ_str = call_string;
	message(fmtstr, fmt_lst, 1);

	call_string = "		display, colormap, color, format);\n\n";
	message(call_string, fmt_lst, 0);
	(void)strcpy(fmtstr, "The parameter values were as follows... \n");
	message(fmtstr, fmt_lst, 0);
								  
	XSync(display_arg, 0);

	if (regr_args.l_flags.chksta  == 1)
			ss_status = save_stat(dpy_msk | win_msk , 
				    gc_id, display_arg, drawable_id);
					
	first_error = 0;	/* no errors encountered yet */
								       
   tet_infoline("TEST: Calling XcmsAllocColor");
	errflg = 0;
	svc_ret_value = XcmsAllocColor(display, colormap, &color, 
			format);
	XSync(display_arg, 0);

	/* no colormap by default */
	r_wait(display_arg, window_arg, time_delay, None);	
	if (regr_args.l_flags.chksta  == 1) 
		stat_status = chek_stat(dpy_msk | win_msk , gc_id,
				 display_arg, drawable_id, ss_status);
	else                              
		stat_status = REGR_NORMAL;

	/******
	* check Success returns with expected returns
	******/
	if ((!errflg) && (!chkflg)) 
		if ((badstat(display_arg, estatus, Success)) != REGR_NORMAL)
			errflg = 1;
	/******
	* verify the results of the service if successful completion.
	******/
	if ((regr_args.l_flags.check) &&
			(errflg == 0) &&
			(stat_status == REGR_NORMAL))
	{
		check_dec(XcmsSuccess, svc_ret_value, "return value") ;
		tmpRGB = (goodColorSpec.red &
			((0xFFFF << (16 - ccc_good->visual->bits_per_rgb)) & 0xFFFF));
		check_dec(tmpRGB, color.spec.RGB.red, "red") ;
		tmpRGB = (goodColorSpec.green &
			((0xFFFF << (16 - ccc_good->visual->bits_per_rgb)) & 0xFFFF));
		check_dec(tmpRGB, color.spec.RGB.green, "green") ;
		tmpRGB = (goodColorSpec.blue &
			((0xFFFF << (16 - ccc_good->visual->bits_per_rgb)) & 0xFFFF));
		check_dec(tmpRGB, color.spec.RGB.blue, "blue") ;
	}
	XSync(display_arg, 0);

	/******
	* cleanup code for this service.
	******/
	if (regr_args.l_flags.cleanup)
	{
		cleanup_status = REGR_NORMAL;
	}
	XSync(display_arg, 0);

	/* if there was an error ...     */
	if (errflg) 
	{ 	
    		errcnt++;   /* ...increment the error count  */
    		(void)strcpy(fmtstr, "\nEnd of error report\n");
    		message(fmtstr, fmt_lst, 0);
    		(void)strcpy(fmtstr, "*********************\n");
    		message(fmtstr, fmt_lst, 0);
		tet_result(TET_FAIL);
	}

	/*****
	* clear all flags
	*****/
	chkflg = 0;
	regr_args.l_flags.bufrout = 0;

	dumpbuf();
}   /* end of svccmsAllocColor service routine */

int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

#if XT_X_RELEASE > 4
	display_arg = Dsp;
	/*
 	* Create a GC to save environmental data in
 	*/
	gc_save = XCreateGC(display_arg, 
			XRootWindow(display_arg,XDefaultScreen(display_arg)),
			(unsigned long)0,(XGCValues *)0);

 	report_purpose(1);

	report_assertion("Assertion XcmsAllocColor-1.(C)");
	report_assertion("If the implementation is X11R5 or later: A call to");
	report_assertion("XcmsAllocColor shall allocate a device-independent color and");
	report_assertion("return the pixel value of the color cell and the color");
	report_assertion("specification actually allocated.");
	regr_args.l_flags.check = 0;
	regr_args.l_flags.nostat = 0;
	regr_args.l_flags.perf = 0;
	regr_args.l_flags.setup = 0;
	regr_args.l_flags.cleanup = 0;
	regr_args.l_flags.chksta = 0;
	regr_args.l_flags.chkdpy = 0;
	regr_args.l_flags.verbose = 0;
	regr_args.iter = 1;	/* execute service once	*/
	estatus[0] = 1;


	/******
 	* User defined initialization code for test case sets
 	******/
	display_good = display_arg;

	/*****
 	* Test wide set up
 	*****/

        screen_good = XDefaultScreen(display_good);
        depth_good = DisplayPlanes( display_good, screen_good );
        visual_good = XDefaultVisual(display_good, screen_good );

        if ((visual_good->class == StaticGray) ||
              (visual_good->class == StaticColor) ||
              (visual_good->class == TrueColor))
            writeable_colormaps = 0 ;

        if (writeable_colormaps) {
		estatus[0] = 1;
		estatus[1] = Success;

		sprintf(tmpbuf, "PREP: determining the color spec for %s",
			config.good_colorname);
		tet_infoline(tmpbuf);
      colormap_good = XDefaultColormap(display_good, screen_good );
		if (!XParseColor(display_good, colormap_good, config.good_colorname,
			&goodColorSpec))
			{ tet_result(TET_UNRESOLVED); return; }

      ccc_good = XcmsCCCOfColormap(display_good, colormap_good) ;
		sprintf(tmpbuf, "INFO: bits_per_rgb(%d)", ccc_good->visual->bits_per_rgb);
		tet_infoline(tmpbuf);

		if ((regr_args.l_flags.good == 0) || (estatus[1] == Success)) 
		{
			regr_args.l_flags.check = 1;
			regr_args.l_flags.setup = 1;
			regr_args.l_flags.cleanup = 1;
			regr_args.l_flags.chksta = 0;
			regr_args.l_flags.chkdpy = 0;

			{
			    format_good = XcmsRGBFormat ;
			    cmsColorSpec.format = XcmsRGBFormat ;
			    cmsColorSpec.pixel = goodColorSpec.pixel;
			    cmsColorSpec.spec.RGB.red = goodColorSpec.red;
			    cmsColorSpec.spec.RGB.green = goodColorSpec.green;
			    cmsColorSpec.spec.RGB.blue = goodColorSpec.blue;
			    svccmsAllocColor(display_good, colormap_good, cmsColorSpec,
					format_good);

			}
			tet_result(TET_PASS);
	    } /* end if */
        } 
	else
		{
      tet_infoline("colormap is not writeable");
		tet_result(TET_UNSUPPORTED);
		}
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif
}

/* Including from file Mdefcode.tmc.1116 */
/* End of included file Mdefcode.tmc.1116 */

static void t002(){


 	report_purpose(2);

	report_assertion("Assertion XcmsAllocColor-2.(C)");
	report_assertion("If the implementation is X11R5 or later: If the value for");
	report_assertion("the colormap argument does not name a defined colormap, a");
	report_assertion("call to XcmsAllocColor shall return the BadColor error code.");
#if XT_X_RELEASE > 4
	display_arg = Dsp;

	/*
 	* Create a GC to save environmental data in
 	*/
	gc_save = XCreateGC(display_arg, 
			XRootWindow(display_arg,XDefaultScreen(display_arg)),
			(unsigned long)0,(XGCValues *)0);

	regr_args.l_flags.check = 0;
	regr_args.l_flags.nostat = 0;
	regr_args.l_flags.perf = 0;
	regr_args.l_flags.setup = 0;
	regr_args.l_flags.cleanup = 0;
	regr_args.l_flags.chksta = 0;
	regr_args.l_flags.chkdpy = 0;
	regr_args.l_flags.verbose = 0;
	regr_args.iter = 1;	/* execute service once	*/
	estatus[0] = 1;


	/******
 	* User defined initialization code for test case sets
 	******/
	display_good = display_arg;

	/*****
 	* Test wide set up
 	*****/
        screen_good = XDefaultScreen(display_good);
        depth_good = DisplayPlanes( display_good, screen_good );
        visual_good = XDefaultVisual(display_good, screen_good );

        if ((visual_good->class == StaticGray) ||
              (visual_good->class == StaticColor) ||
              (visual_good->class == TrueColor))
            writeable_colormaps = 0 ;

        if (writeable_colormaps) 
	{
		estatus[0] = 1;
		estatus[1] = BadColor ;

      colormap_good = XDefaultColormap(display_good, screen_good );

		sprintf(tmpbuf, "PREP: determining the color spec for %s",
			config.good_colorname);
		tet_infoline(tmpbuf);
      colormap_good = XDefaultColormap(display_good, screen_good );
		if (!XParseColor(display_good, colormap_good, config.good_colorname,
			&goodColorSpec))
			{ tet_result(TET_UNRESOLVED); return; }

      ccc_good = XcmsCCCOfColormap(display_good, colormap_good) ;

		if ((regr_args.l_flags.good == 0) || (estatus[1] == Success)) 
		{
			regr_args.l_flags.check = 0;
			regr_args.l_flags.setup = 1;
			regr_args.l_flags.cleanup = 1;
			regr_args.l_flags.chksta = 0;
			regr_args.l_flags.chkdpy = 0;

			chkflg = 1;

			format_good = XcmsRGBFormat ;
			cmsColorSpec.format = XcmsRGBFormat ;
			cmsColorSpec.pixel = goodColorSpec.pixel;
			cmsColorSpec.spec.RGB.red = goodColorSpec.red;
			cmsColorSpec.spec.RGB.green = goodColorSpec.green;
			cmsColorSpec.spec.RGB.blue = goodColorSpec.blue;
			svccmsAllocColor(display_good, -999, cmsColorSpec, format_good);
			tet_result(TET_PASS);
		} /* end if */
	} 
	else
		{
      tet_infoline("colormap is not writeable");
		tet_result(TET_UNSUPPORTED);
		}
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif
}

/* Including from file Mdefcode.tmc.1116 */
/* End of included file Mdefcode.tmc.1116 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = r5_startup;
void	(*tet_cleanup)() = r5_cleanup;
