/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtVaGetSubvalues()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

typedef struct _instance_variables {
	long foreground;
	String label;
} instance_variable_rec;
static XtResource resources[] = {
	{
	XtNforeground,
	XtCForeground,
	XtRPixel, sizeof(Pixel),
	XtOffsetOf(instance_variable_rec, foreground),
	XtRString, "XtDefaultforeground"
	},
	{
	XtNlabel,
	XtCLabel,
	XtRString, sizeof(String),
	XtOffsetOf(instance_variable_rec, label),
	XtRString, "XtDefaultLabel"
	},
};

void XtWMHl_Proc(str1)
String str1;
{
	avs_set_event(1,1);
}
void XtWMH_Proc(str1, str2, str3, str4, str5, car)
String str1, str2, str3, str4, *str5;
Cardinal *car;
{
	avs_set_event(1,1);
}


#define T_XtVaGetSubvalues	1
char    *TestName = "XtVaGetSubvalues";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

instance_variable_rec base;
Cardinal num_resources;
Pixel pixel;
char *string;
Cardinal num_args;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtVaGetSubvalues-1.(A)");
	report_assertion("A call to void XtVaGetSubvalues(base, resources,");
	report_assertion("num_resources,...) shall copy the resource value from the");
	report_assertion("structure pointed to by base for each resource name");
	report_assertion("specified in the varargs style variable argument list of");
	report_assertion("name/value pairs that is present in the resource list");
	report_assertion("specified by resources to the location specified by the");
	report_assertion("corresponding value field.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tvagtsval1", "XtVaGetSubvalues");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Initialize the base address");
	XtGetApplicationResources(topLevel, &base, resources, 2,
			(ArgList) NULL, (Cardinal)0);
	tet_infoline("PREP: Set subvalues");
	XtVaSetSubvalues(&base, resources, 2, XtNforeground, 1,
		 XtNlabel, "Hello World", NULL);
	tet_infoline("PREP: Get subvalues");
	XtVaGetSubvalues(&base, resources, 2, XtNforeground, &pixel,
		 XtNlabel, &string, NULL);
	tet_infoline("TEST: Retrieved subvalues");
	check_dec(1, pixel , XtNforeground);
	check_str("Hello World", string , XtNlabel);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1120 */
/* End of included file Mdefcode.tmc.1120 */

static void t002(){

instance_variable_rec base;
Cardinal num_resources;
Pixel pixel;
char *string;
Cardinal num_args;
pid_t pid2;
int status;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtVaGetSubvalues-2.(A)");
	report_assertion("When a member in the variable argument list is of type");
	report_assertion("XtVaTypedArg a call to void XtVaGetSubvalues(base,");
	report_assertion("resources, num_resources,...) shall issue a warning message");
	report_assertion("and ignore the entry.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_xt_hier("Tvagtsval1", "XtVaGetSubvalues");
	XtAppSetWarningMsgHandler(app_ctext, XtWMH_Proc);
	XtAppSetWarningHandler(app_ctext, XtWMHl_Proc);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Initialize the base address");
	XtGetApplicationResources(topLevel, &base, resources, 2,
			(ArgList) NULL, (Cardinal)0);
	tet_infoline("PREP: Set subvalues");
	XtVaSetSubvalues(&base, resources, 2, XtNforeground, 1,
		 XtNlabel, "Hello World", NULL);
	tet_infoline("PREP: Get subvalues");
	
	XtVaGetSubvalues(&base, resources, 2, XtNforeground, &pixel,
		 XtVaTypedArg, XtNlabel, XtRString, string, 0, NULL);
	tet_infoline("TEST: Retrieved subvalues");
	check_dec(1, pixel , XtNforeground);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Warning handler is called");
	status = avs_get_event(1);
	check_dec(1, status, "calls to warning handler count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1120 */
/* End of included file Mdefcode.tmc.1120 */

static void t003(){

instance_variable_rec base;
Cardinal num_resources;
Pixel pixel;
char *string;
Cardinal num_args;
pid_t pid2;
XtVarArgsList thelist;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtVaGetSubvalues-3.(A)");
	report_assertion("On a call to void XtVaGetSubvalues(base, resources,");
	report_assertion("num_resources,...) when the name XtVaNestedList is");
	report_assertion("specified in place of a resource name in the variable");
	report_assertion("argument list it shall interpret the next argument as a");
	report_assertion("value specifying another varargs style variable argument");
	report_assertion("list and logically insert it in the original list at the");
	report_assertion("point of declaration.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tvagtsval1", "XtVaGetSubvalues");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Initialize the base address");
	XtGetApplicationResources(topLevel, &base, resources, 2,
			(ArgList) NULL, (Cardinal)0);
	tet_infoline("PREP: Set subvalues");
	XtVaSetSubvalues(&base, resources, 2, XtNforeground, 1,
		 XtNlabel, "Hello World", NULL);
	tet_infoline("PREP: Get subvalues");
	thelist=XtVaCreateArgsList(NULL, XtNforeground, &pixel, NULL);
	XtVaGetSubvalues(&base, resources, 2, XtVaNestedList, thelist,
		 XtNlabel, &string, (char *)NULL);
	tet_infoline("TEST: Retrieved subvalues");
	check_dec(1, pixel , XtNforeground);
	check_str("Hello World", string , XtNlabel);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1120 */
/* End of included file Mdefcode.tmc.1120 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
