/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtTranslateCoords()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

void Popup(w, client_data, call_data)
Widget w;
XtPointer client_data; /* cast to topLevel */
XtPointer call_data;
{
	Widget topLevel = (Widget) client_data;
	Widget menuw = (Widget) call_data;
	Position width, height;
	Position ret_x, ret_y;
	Position get_x, get_y;
	tet_infoline("PREP: Get the coordinates of the middle of topLevel widget");
	XtVaGetValues(topLevel, XtNwidth, &width, XtNheight, &height, NULL);
	tet_infoline("PREP: Translate coordinates");
	XtTranslateCoords(topLevel,	/* Widget */
	 (Position) width/2,	/* x */
	 (Position) height/2,	/* y */
	 &ret_x, &ret_y);	 /* coords on root window */
	tet_infoline("PREP: Move popup shell to this position");
	XtVaSetValues(menuw, XtNx, ret_x, XtNy, ret_y, NULL);
	tet_infoline("PREP: Popup the shell");
	XtPopup(menuw, XtGrabNone);
	tet_infoline("PREP: Get its coordinates");
	XtVaGetValues(menuw, XtNx, &get_x, XtNy, &get_y, NULL);
	tet_infoline("TEST: Coordinates");
	check_dec(ret_x, get_x, "x co-ordinate");
	check_dec(ret_y, get_y, "x co-ordinate");
}


#define T_XtTranslateCoords	1
char    *TestName = "XtTranslateCoords";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Widget labelw_good;
Widget menuw;
Widget pushb_good, rowcolw_good;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtTranslateCoords-1.(A)");
	report_assertion("A call void XtTranslateCoords(w, x, y, rootx_return,");
	report_assertion("rooty_return) shall translate the widget-relative coordinate");
	report_assertion("pair specified by x and y to root window absolute");
	report_assertion("coordinates and return the root-relative x and y coordinates");
	report_assertion("in rootx_return and rooty_return respectively.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Ttranslcd1", "XtTranslateCoords");
	tet_infoline("PREP: Create labelw_good widget Press Me");
	labelw_good = (Widget) CreateLabelWidget("Press Me", boxw1);
	tet_infoline("PREP: Create a shell");
	menuw = XtVaCreatePopupShell("menuw",
				overrideShellWidgetClass,
				labelw_good, NULL);
	tet_infoline("PREP: Create a rowcolw_good widget");
	rowcolw_good = (Widget) CreateRowColWidget(menuw);
	tet_infoline("PREP: Create pushb_good button Hello in rowcolw_good widget");
	pushb_good = (Widget) CreatePushButtonGadget("Hello",
				 rowcolw_good);
	tet_infoline("PREP: Add callback function Popup");
	XtAddCallback(labelw_good, XtNdestroyCallback,
			Popup, topLevel);
	tet_infoline("PREP: Create windows for widget and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Invoke callback function Popup");
	XtCallCallbacks(labelw_good, XtNdestroyCallback, menuw);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.2676 */
/* End of included file Mdefcode.tmc.2676 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
