/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   XtWorkProcId
 *   XtAppAddWorkProc()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

char client_stuff[] = "These are the times that try men's souls";

Boolean XtWKP_Proc(client_data)
XtPointer client_data;
{
int count;

	if (strcmp(client_data, client_stuff) != 0) {
		sprintf(ebuf, "ERROR: Expected client_data = %s, received %s", client_stuff, client_data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}

	/*let it get called a few times*/
	count = avs_get_event(1);
	if (count == 10)
		exit(0);
	else {
		avs_set_event(1,++count);
		return False;
	}
}
Boolean XtWKP_Proc5(client_data)
XtPointer client_data;
{
int count;

	tet_infoline("TEST: client_data passed to work procedure");
	if (strcmp(client_data, client_stuff) != 0) {
		sprintf(ebuf, "ERROR: Expected client_data = %s, received %s", client_stuff, client_data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}

	/*let it get called a few times*/
	count = avs_get_event(1);
	if (count == 10)
		exit(0);
	else {
		avs_set_event(1,++count);
		return False;
	}
}

Boolean XtWKP_Proc3(client_data)
XtPointer client_data;
{
int count;

	/*let it get called a few times*/
	count = avs_get_event(1);
	if (count < 5) {
		avs_set_event(1,++count);
		return False;
	}
	/*then no more*/
	else
		return True;
}

Boolean XtWKP_Head(client_data)
XtPointer client_data;
{
	Widget topLevel = (Widget) client_data;
	sprintf(ebuf, "ERROR: Unexpected invocation of XtWKP_Head");
	tet_infoline(ebuf);
	tet_result(TET_FAIL);
	exit(0);
}

Boolean XtWKP_Tail(client_data)
XtPointer client_data;
{
	Widget topLevel = (Widget) client_data;
	avs_set_event(1,1);
	exit(0);
}

/* procedure XtTMO_Proc to be invoked */
void XtTMO_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	exit(0);
}

Boolean XtWKP_Proc7(client_data)
XtPointer client_data;
{
	avs_set_event(2, avs_get_event(1));
	exit(0);
}
Boolean XtWKP_Proc6(client_data)
XtPointer client_data;
{
	avs_set_event(1, avs_get_event(1)+1);
	if (avs_get_event(1) == 1) {
		XtAppAddWorkProc(app_ctext, XtWKP_Proc7, client_stuff);
		return(False);
	}
	if (avs_get_event(1) == 5) {
		return(True);
	}
	return(False);
}
extern char *event_names[];

/*
** Registered procedure Proc
*/
void XtEVT_Proc(w, client_data, event, continue_to_dispatch)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch;
{
	return;
}

/* procedure XtTMO_Proc to be invoked */


#define T_XtAppAddWorkProc	1
char    *TestName = "XtAppAddWorkProc";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

pid_t pid2;
int status;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtAppAddWorkProc-1.(A)");
	report_assertion("A successful call to XtWorkProcId");
	report_assertion("XtAppAddWorkProc(app_context, proc, client_data) shall");
	report_assertion("register proc as the work procedure that will be called when");
	report_assertion("the application_context specified by app_context waits for");
	report_assertion("an event input and returns a unique identifier for the work");
	report_assertion("procedure.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapawkprc1", "XtAppAddWorkProc");
	tet_infoline("PREP: Add work procedure XtWKP_Proc");
	XtAppAddWorkProc(app_ctext, XtWKP_Proc, client_stuff);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Work procedure is invoked");
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	status = avs_get_event(1);
	check_dec(10, status, "XtWKP_Proc invoked count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2364 */
/* End of included file Mdefcode.tmc.2364 */

static void t002(){

pid_t pid2;
int status;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtAppAddWorkProc-2.(A)");
	report_assertion("When multiple procedures are registered by calls to");
	report_assertion("XtWorkProcId XtAppAddWorkProc(app_context, proc,");
	report_assertion("client_data) the most recently registered procedure shall be");
	report_assertion("called when the specified application context waits for an");
	report_assertion("event input.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapawkprc2", "XtAppAddWorkProc");
	tet_infoline("PREP: Add work procedure XtWKP_Head");
	XtAppAddWorkProc(app_ctext, XtWKP_Head, (Widget)topLevel);
	tet_infoline("PREP: Add work procedure XtWKP_Tail");
	XtAppAddWorkProc(app_ctext, XtWKP_Tail, (Widget)topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Procedure XtWKP_Head not invoked");
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	status = avs_get_event(1);
	tet_infoline("TEST: Procedure XtWKP_Tail is invoked");
	check_dec(1, status, "XtWKP_Tail invoked count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2364 */
/* End of included file Mdefcode.tmc.2364 */

static void t003(){

pid_t pid2;
int status;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtAppAddWorkProc-3.(A)");
	report_assertion("When a work procedure registered by a call to XtWorkProcId");
	report_assertion("XtAppAddWorkProc(app_context, proc, client_data) returns");
	report_assertion("True it shall be unregistered and not called when the");
	report_assertion("specified application context next waits for event input.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapawkprc1", "XtAppAddWorkProc");
	tet_infoline("PREP: Add work procedure XtWKP_Proc");
	XtAppAddWorkProc(app_ctext, XtWKP_Proc3, client_stuff);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register timeout procedure");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	tet_infoline("TEST: Work procedure unregistered after returns True");
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	status = avs_get_event(1);
	check_dec(5, status, "XtWKP_Proc invoked count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2364 */
/* End of included file Mdefcode.tmc.2364 */

static void t004(){

pid_t pid2;
int status;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtAppAddWorkProc-4.(A)");
	report_assertion("When a work procedure registered by a call to XtWorkProcId");
	report_assertion("XtAppAddWorkProc(app_context, proc, client_data) registers a");
	report_assertion("work procedure the newly added procedure shall have lower");
	report_assertion("priority.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapawkprc1", "XtAppAddWorkProc");
	tet_infoline("PREP: Add work procedure");
	XtAppAddWorkProc(app_ctext, XtWKP_Proc6, client_stuff);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Second work procedure is not invoked until first in unregistered");
	status = avs_get_event(1);
	check_dec(5, status, "first procedure invocations count");
	status = avs_get_event(2);
	check_dec(5, status, "time first procedure was invoked before second");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2364 */
/* End of included file Mdefcode.tmc.2364 */

static void t005(){

pid_t pid2;
int status;
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtAppAddWorkProc-5.(A)");
	report_assertion("A successful call to XtWorkProcId");
	report_assertion("XtAppAddWorkProc(app_context, proc, client_data) shall cause");
	report_assertion("client_data to be passed to proc when it is invoked.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapawkprc1", "XtAppAddWorkProc");
	tet_infoline("PREP: Add work procedure");
	XtAppAddWorkProc(app_ctext, XtWKP_Proc5, client_stuff);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Work procedure is invoked");
	XtAppMainLoop(app_ctext);
	LKROF(pid2, AVSXTTIMEOUT-2);
	status = avs_get_event(1);
	check_dec(10, status, "work procedure invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2364 */
/* End of included file Mdefcode.tmc.2364 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
