/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XShapeCombineShape()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/shape.h>
extern Display *display;



#define T_XShapeCombineShape	1
char    *TestName = "XShapeCombineShape";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Window  window;
Window  dest;
Window  src;
/* x_off , y_off, height and width  */
XRectangle rects[] = { 150, 150, 100, 100 }; 
XRectangle *rect_return;
int count, order;
Window root;
int x, y;
unsigned int width, height;
unsigned int border_width;
unsigned int depth;
int BorderPixel, BackgroundPixel;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XShapeCombineShape-1.(A)");
	report_assertion("A call to void XShapeCombineShape(display, dest, dest_kind,");
	report_assertion("x_off, y_off, src, src_kind, op) shall perform a");
	report_assertion("CombineShape operation by combining the client region");
	report_assertion("indicated by src_kind, of the source window src having an");
	report_assertion("offset from the window origin by x_off and y_off with the");
	report_assertion("client region, indicated by dest_kind of the destination");
	report_assertion("window dest, and the result is stored as the client region");
	report_assertion("of the destination window dest.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	tet_infoline("PREP: Open display and create window");
	window = (Window) avs_xext_init();
	tet_infoline("PREP: Get geometry of window");
	XGetGeometry(display,
		   window,
		   &root,
		   &x, &y,
		   &width, &height,
		   &border_width,
		   &depth
		   );
	tet_infoline("PREP: Create src window");
	BorderPixel = XWhitePixel(display,XDefaultScreen(display));
	BackgroundPixel = XBlackPixel(display,XDefaultScreen(display));
	src = XCreateSimpleWindow(display,
	   (Window)XRootWindow(display, XDefaultScreen(display)),
	    x,
	    y,
	    100,
	    100,
	    0,
	    BorderPixel,
	    BackgroundPixel
	    );
	tet_infoline("PREP: Create destination window");
	dest = XCreateSimpleWindow(display,
	   (Window)XRootWindow(display, XDefaultScreen(display)),
	    (x + 100),
	    (y + 100),
	    200,
	    200,
	    0,
	    BorderPixel,
	    BackgroundPixel
	    );
	tet_infoline("PREP: Combine shape using default regions");
	XShapeCombineShape(display, dest, ShapeBounding,
		   150, 150, src,
		   ShapeBounding, ShapeSet);
	XMapWindow (display, dest);
	XSync (display, 0);
	tet_infoline("PREP: Get count and order of rectangles");
	rect_return = (XRectangle *)XShapeGetRectangles(display,
			    dest, ShapeBounding,
			    &count, &order);
	tet_infoline("TEST: Check number of rectangles in default region is one");
	check_dec(1, count, "count");
	tet_infoline("TEST: Rectangle values");
	check_dec(rects[0].x, rect_return->x, "rect_return->x");
	check_dec(rects[0].y, rect_return->y, "rect_return->y");
	check_dec(rects[0].width, rect_return->width,
		         "rect_return->width");
	check_dec(rects[0].height, rect_return->height, "rect_return->height");

	LKROF(pid2, AVSXTTIMEOUT);
        tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.354972 */
/* End of included file Mdefcode.tmc.354972 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
