/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XReconfigureWMWindow(display, w, screen_number, value_mask, values)
 *   Display		*display;
 *   Window		w;
 *   int		screen_number;
 *   unsigned int	value_mask;
 *   XWindowChanges	*values;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XReconfigureWMWindow	1
char    *TestName = "XReconfigureWMWindow";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XReconfigureWMWindow function
 */
static Display		*display;
static Window		w;
static int		screen_number;
static unsigned int	value_mask;
static XWindowChanges	*values;


static int 	StatusReturn;

XWindowChanges	wchanges;

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = DRW(Dsp);
	screen_number = DefaultScreen(Dsp);
	value_mask = 0;
	values = &wchanges;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Status			status;
XEvent			ev;
int			nevents = 0;
XVisualInfo		*vp;
XWindowChanges		changes;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XReconfigureWMWindow-1.(A)");
	report_assertion("A call to XReconfigureWMWindow issues a ConfigureWindow");
	report_assertion("request on the specified top-level window named by the w");
	report_assertion("argument.");

	report_strategy("Create a window using XCreateWindow.");
	report_strategy("Select ConfigureNotify events on the window using XSelectInput with SubstructureNotifyMask.");
	report_strategy("Generate a ConfigureWindow event on the window using XReconfigureWMWindow.");
	report_strategy("Verify that the call returned non-zero.");
	report_strategy("Verify that a single event was generated.");
	report_strategy("Verify that the event type was ConfigureWindow.");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);
	w = makewin(display, vp);
	XSelectInput(display, w, StructureNotifyMask);

	screen_number = DefaultScreen(display);
	value_mask = CWBorderWidth;
	changes.border_width = 5;
	values = &changes;

	startcall(display);
	if (isdeleted())
		return;
	status = XReconfigureWMWindow(display, w, screen_number, value_mask, values);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status == 0) {
		report("%s() returned zero.", TestName);
		FAIL;
	} else
		CHECK;

	if( (nevents = getevent(display, &ev)) == 0 ) {
		report("No event was generated.");
		FAIL;
		
	} else {

		CHECK;
		if(nevents != 1) {
			delete("There were %d events generated instead of 1.", nevents);
			return;
		} else	
			CHECK;

		if(ev.type != ConfigureNotify) {
			report("The type component of the generated event was %d instead of ConfigureWindow (%d)",
				ev.xclient.type, ConfigureNotify);
			FAIL;		
		} else
			CHECK;
	}

	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Status			status;
XEvent			rev, expectev;
int			nevents = 0;
int			i;
XVisualInfo		*vp;
XWindowChanges		changes;
unsigned long		event_mask[2];
unsigned long		valuemask = CWSibling /**/| CWStackMode/**/ | CWX | CWY | CWWidth | CWHeight | CWBorderWidth;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XReconfigureWMWindow-2.(A)");
	report_assertion("When the ConfigureWindow request fails with a BadMatch");
	report_assertion("error, then a call to XReconfigureWMWindow sends a synthetic");
	report_assertion("ConfigureRequestEvent to the root of the window specified by");
	report_assertion("the w argument, with the event containing the same");
	report_assertion("configuration parameters specified by the values and");
	report_assertion("valuemask arguments and having a window element of w and a");
	report_assertion("parent element equal to the receiving root window, using an");
	report_assertion("event mask of SubstructureRedirectMask|");
	report_assertion("SubstructureNotifyMask and returns non-zero.");

	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Select ConfigureRequest events using XSelectInput with SubstructureNotifyMask.");
	report_strategy("Call XReconfigureWMWindow using the root window as a sibling and no specified StackMode.");
	report_strategy("Verify that the call did not return zero.");
	report_strategy("Verify that one ConfigureRequest event is generated using XNextEvent.");
	report_strategy("Verify that the event components are correct.");
	report_strategy("");
	report_strategy("Select ConfigureRequest events using XSelectInput with SubstructureRedirectMask.");
	report_strategy("Call XReconfigureWMWindow using the root window as a sibling and no specified StackMode.");
	report_strategy("Verify that the call did not return zero.");
	report_strategy("Verify that one ConfigureRequest event is generated using XNextEvent.");
	report_strategy("Verify that the event components are correct.");

	tpstartup();
	setargs();
	event_mask[0] = SubstructureNotifyMask;
	event_mask[1] = SubstructureRedirectMask;

	resetvinf(VI_WIN);
	nextvinf(&vp);
	w = makewin(display, vp);
	
	expectev.type = ConfigureRequest;
	expectev.xany.display = display;
	
	expectev.xconfigurerequest.type = ConfigureRequest;
	expectev.xconfigurerequest.send_event = True;
	expectev.xconfigurerequest.display = display;
	expectev.xconfigurerequest.window = w;
	expectev.xconfigurerequest.parent = DRW(display);
	expectev.xconfigurerequest.x = 1;
	expectev.xconfigurerequest.y = 2;
	expectev.xconfigurerequest.width = 3;
	expectev.xconfigurerequest.height = 4;
	expectev.xconfigurerequest.border_width = 5;
	expectev.xconfigurerequest.above = DRW(display);
	expectev.xconfigurerequest.detail = Above;
	expectev.xconfigurerequest.value_mask = valuemask;
	
	screen_number = DefaultScreen(display);
	value_mask = valuemask; 
	changes.x = 1;
	changes.y = 2;
	changes.width = 3;
	changes.height = 4;
	changes.border_width = 5;
	changes.sibling = DRW(display);
	changes.stack_mode = Above;
	values = &changes;
	

	for(i=0; i<2; i++) {

		startcall(display);
		XSelectInput(display, DRW(display), event_mask[i]);
		endcall(display);

		if(geterr() != Success) {
			delete("XSelectInput() failed with an event mask of 0x%lx.", event_mask[i]);
			return;
		} else
			CHECK;

		startcall(display);
		if (isdeleted())
			return;
		status = XReconfigureWMWindow(display, w, screen_number, value_mask, values);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
	
		if(status == 0) {
			report("%s() returned zero.", TestName);
			FAIL;
		} else
			CHECK;
	
		rev.type = -1;
		if( (nevents = getevent(display, &rev)) == 0 ) {
			report("No event was generated.");
			FAIL;
	
		} else {
	
			CHECK;
			if(nevents != 1){
				delete("There were %d events generated instead of 1.", nevents);
				return;
			} else	
				CHECK;
	
			if( checkevent( &expectev, &rev) != 0)
				FAIL;
			else
				CHECK;
	
		}
	}

	CHECKPASS(10);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.360148 */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XReconfigureWMWindow-3.(B)");
	report_assertion("When the ConfigureRequestEvent is not successfully sent,");
	report_assertion("then a call to XReconfigureWMWindow returns zero.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.360148 */

static void t004(){

Status			status;
XVisualInfo		*vp;
XWindowChanges		changes;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XReconfigureWMWindow-4.(A)");
	report_assertion("When the value_mask argument contains the bits CWWidth or");
	report_assertion("CWHeight and either of the width or height components of the");
	report_assertion("XWindowChanges structure named by the values argument is");
	report_assertion("zero, then a BadValue error occurs.");

	report_strategy("Create a window using XCreateWindow.");
	report_strategy("Configure the window to have a height of zero using XReconfigureWMWindow");
	report_strategy("Verify that a BadValue error was generated.");
	report_strategy("Configure the window to have a width of zero using XReconfigureWMWindow");
	report_strategy("Verify that a BadValue error was generated.");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);
	w = makewin(display, vp);

	screen_number = DefaultScreen(display);
	value_mask = CWHeight ;
	changes.height = 0;
	values = &changes;
	startcall(display);
	if (isdeleted())
		return;
	status = XReconfigureWMWindow(display, w, screen_number, value_mask, values);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if(geterr() == BadValue)
		CHECK;

	changes.width = 0;
	value_mask = CWWidth;
	startcall(display);
	if (isdeleted())
		return;
	status = XReconfigureWMWindow(display, w, screen_number, value_mask, values);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if(geterr() == BadValue)
		CHECK;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

Status status;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XReconfigureWMWindow-5.(A)");
	report_assertion("When the window argument does not name a valid window, then");
	report_assertion("a BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
        A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	status = XReconfigureWMWindow(display, w, screen_number, value_mask, values);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

        if (geterr() == BadWindow)
                PASS;
        else
                FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
