/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtUnrealizeWidget()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;


#define T_XtUnrealizeWidget	1
char    *TestName = "XtUnrealizeWidget";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Window window_bad;
Widget widget_good, labelw_good;
Widget rowcolw_good;
Display *display_good;
Boolean status;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtUnrealizeWidget-1.(A)");
	report_assertion("When w is realized a call to void XtUnrealizeWidget(w)");
	report_assertion("shall destroy the windows associated with the widget w and");
	report_assertion("its descendants.");
	FORK(pid);
	initconfig();

	avs_xt_hier("Tunrlzwgt1", "XtUnrealizeWidget");
	tet_infoline("PREP: Create rowcolw_good widget in boxw1 widget");
	rowcolw_good = (Widget) CreateRowColWidget(boxw1);
	tet_infoline("PREP: Create test label widget `Hello' in rowcolw_good widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", rowcolw_good);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Unrealize rowcolw_good widget");
	XtUnrealizeWidget(rowcolw_good);
	tet_infoline("TEST: Root widget rowcolw_good is unrealized");
	status = XtIsRealized(rowcolw_good);
	check_dec(False, status, "XtIsRealized return value");
	tet_infoline("TEST: Leaf widget labelw_good is unrealized");
	status = XtIsRealized(labelw_good);
	check_dec(False, status, "XtIsRealized return value");
	tet_infoline("TEST: Window of rowcolw_good widget is destroyed");
	if ((window_bad = XtWindow(rowcolw_good)) > 0) {
		sprintf(ebuf, "ERROR: Expected Invalid window id received %d", window_bad);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.361992 */
/* End of included file Mdefcode.tmc.361992 */

static void t002(){

Window window_bad;
Widget widget_good, labelw_good;
Widget rowcolw_good;
Display *display_good;
Boolean status;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtUnrealizeWidget-2.(A)");
	report_assertion("When w is unrealized a call to void XtUnrealizeWidget(w)");
	report_assertion("shall have no effect.");
	FORK(pid);
	initconfig();

	avs_xt_hier("Tunrlzwgt1", "XtUnrealizeWidget");
	tet_infoline("PREP: Create rowcolw_good widget in boxw1 widget");
	rowcolw_good = (Widget) CreateRowColWidget(boxw1);
	tet_infoline("PREP: Create test label widget `Hello' in rowcolw_good widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", rowcolw_good);
	tet_infoline("PREP: Unrealize rowcolw_good widget");
	XtUnrealizeWidget(rowcolw_good);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.361992 */
/* End of included file Mdefcode.tmc.361992 */

/* Including from file Mdefcode.tmc.361992 */
static void t003(){

pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtUnrealizeWidget-3.(B)");
	report_assertion("When w is realized and managed a call to void");
	report_assertion("XtUnrealizeWidget(w) shall remove it from the managed list");
	report_assertion("of its parent.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.361992 */

/* Including from file Mdefcode.tmc.361992 */
static void t004(){

pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtUnrealizeWidget-4.(B)");
	report_assertion("When w is realized a call to void XtUnrealizeWidget(w)");
	report_assertion("shall make a child-to-parent traversal of the widget tree");
	report_assertion("with the widget w as the root and call the procedures on the");
	report_assertion("XtNunrealizeCallback list of each widget that has a callback");
	report_assertion("list resource named unrealizeCallback defined.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.361992 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
