// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// functions:
//   compressedFraction()
//   elementsCompressed()
//   compress()
//   uncompress()
//-----------------------------------------------------------------------------

#ifndef POOMA_ENGINE_COMPRESSEDFRACTION_H
#define POOMA_ENGINE_COMPRESSEDFRACTION_H

//-----------------------------------------------------------------------------
// Overview: 
//
// External functions that can be applied to any engine or container to answer
// questions about compression and to force compression or uncompression.
//
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
//
// double compressedFraction()
//
// Compute the fraction of the total domain that is currently compressed.
//
//-----------------------------------------------------------------------------

template <class Expr>
double compressedFraction(const Expr &expr)
{
  return static_cast<double>(elementsCompressed(expr)) / expr.domain().size();
}


//-----------------------------------------------------------------------------
//
// long elementsCompressed()
//
// Compute the number of the elements that are currently compressed.
//
//-----------------------------------------------------------------------------

template <class Expr>
inline long elementsCompressed(const Expr &expr)
{
  return 0L;
}

//-----------------------------------------------------------------------------
//
// void compress()
//
// (Try to) compress an engine or container.
//
//-----------------------------------------------------------------------------

template <class Expr>
inline void compress(Expr &)
{ }


//-----------------------------------------------------------------------------
//
// void uncompress()
//
// Manually uncompress an engine or container.
//
//-----------------------------------------------------------------------------

template <class Expr>
inline void uncompress(Expr &)
{ }

#endif     // POOMA_ENGINE_COMPRESSEDFRACTION_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: CompressedFraction.h,v $   $Author: swhaney $
// $Revision: 1.4 $   $Date: 2000/06/01 00:21:08 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
