// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

#ifndef POOMA_POOMA_NEWFIELDS_H
#define POOMA_POOMA_NEWFIELDS_H

//-----------------------------------------------------------------------------
// A one-stop-shopping header file that sets up everything one needs to use
// all POOMA Fields (and, by inclusion of Arrays.h, Arrays).
//-----------------------------------------------------------------------------

// Include files

// Arrays:

#include "Pooma/Arrays.h"

// Field class:

#include "NewField/Field.h"

// FieldEngines:

#include "NewField/FieldEngine/FieldEngine.UR.h"
#include "NewField/FieldEngine/FieldEngine.Lagrangian.h"
#include "NewField/FieldEngine/FieldEngine.NoGeometry.h"
#include "NewField/FieldEngine/FieldEngineBase.ExprEngine.h"

// Updaters:

#include "NewField/Updater/ConstantFaceBC.h"

// Other stuff:

#include "NewField/FieldInitializers.h"
#include "NewField/FieldReductions.h"
#include "NewField/PrintField.h"

#endif // POOMA_POOMA_NEWFIELDS_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: NewFields.h,v $   $Author: swhaney $
// $Revision: 1.2 $   $Date: 2000/07/24 23:24:54 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
