/* Author:  G. Jungman
 * RCS:     $Id: bsearch.c,v 1.2 1998/07/05 06:48:52 jungman Exp $
 */
#include "bsearch.h"


unsigned long
interp_bsearch(const double x_array[], double x,
               unsigned long index_lo,
               unsigned long index_hi
               )
{
  int ilo = index_lo;
  int ihi = index_hi;
  while(ihi - ilo > 1) {
    int i = (ihi + ilo)/2;
    if(x_array[i] > x)
      ihi = i;
    else
      ilo = i;
  }
  
  return ilo;
}
