/* Author:  G. Jungman
 * RCS:     $Id: gsl_sf_transport.h,v 1.2 1998/08/21 00:36:58 jungman Exp $
 */
#ifndef GSL_SF_TRANSPORT_H_
#define GSL_SF_TRANSPORT_H_


/* Transport function:
 *   J(n,x) := Integral[ t^n e^t /(e^t - 1)^2, {t,0,x}]
 */


/* J(2,x)
 */
int     gsl_sf_transport_2_impl(double x, double * result);
int     gsl_sf_transport_2_e(double x, double * result);
double  gsl_sf_transport_2(double x);


/* J(3,x)
 */
int     gsl_sf_transport_3_impl(double x, double * result);
int     gsl_sf_transport_3_e(double x, double * result);
double  gsl_sf_transport_3(double x);



#endif  /* !GSL_SF_TRANSPORT_H_ */
