/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.output.NamespaceStack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXOutputter {
    private static final String CVS_ID = "@(#) $RCSfile: SAXOutputter.java,v $ $Revision: 1.18 $ $Date: 2002/01/08 09:17:10 $ $Name: jdom_1_0_b8 $";
    private static final String NAMESPACES_SAX_FEATURE = "http://xml.org/sax/features/namespaces";
    private static final String NS_PREFIXES_SAX_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private static final String LEXICAL_HANDLER_SAX_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private static final String DECL_HANDLER_SAX_PROPERTY = "http://xml.org/sax/properties/declaration-handler";
    private static final String LEXICAL_HANDLER_ALT_PROPERTY = "http://xml.org/sax/handlers/LexicalHandler";
    private static final String DECL_HANDLER_ALT_PROPERTY = "http://xml.org/sax/handlers/DeclHandler";
    private static final String[] attrTypeToNameMap = new String[]{"CDATA", "CDATA", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NMTOKEN", "NMTOKENS", "NOTATION", "NMTOKEN"};
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private DTDHandler dtdHandler;
    private EntityResolver entityResolver;
    private LexicalHandler lexicalHandler;
    private DeclHandler declHandler;
    private boolean declareNamespaces = false;

    public SAXOutputter() {
    }

    public SAXOutputter(ContentHandler contentHandler) {
        this(contentHandler, null, null, null, null);
    }

    public SAXOutputter(ContentHandler contentHandler, ErrorHandler errorHandler, DTDHandler dTDHandler, EntityResolver entityResolver) {
        this(contentHandler, errorHandler, dTDHandler, entityResolver, null);
    }

    public SAXOutputter(ContentHandler contentHandler, ErrorHandler errorHandler, DTDHandler dTDHandler, EntityResolver entityResolver, LexicalHandler lexicalHandler) {
        this.contentHandler = contentHandler;
        this.errorHandler = errorHandler;
        this.dtdHandler = dTDHandler;
        this.entityResolver = entityResolver;
        this.lexicalHandler = lexicalHandler;
    }

    private AttributesImpl addNsAttribute(AttributesImpl attributesImpl, Namespace namespace) {
        if (this.declareNamespaces) {
            if (attributesImpl == null) {
                attributesImpl = new AttributesImpl();
            }
            attributesImpl.addAttribute("", "", "xmlns:" + namespace.getPrefix(), "CDATA", namespace.getURI());
        }
        return attributesImpl;
    }

    private void characters(String string) throws JDOMException {
        char[] cArray = string.toCharArray();
        try {
            this.contentHandler.characters(cArray, 0, cArray.length);
        }
        catch (SAXException sAXException) {
            throw new JDOMException("Exception in characters", sAXException);
        }
    }

    private void comment(String string) throws JDOMException {
        if (this.lexicalHandler != null) {
            char[] cArray = string.toCharArray();
            try {
                this.lexicalHandler.comment(cArray, 0, cArray.length);
            }
            catch (SAXException sAXException) {
                throw new JDOMException("Exception in comment", sAXException);
            }
        }
    }

    private XMLReader createDTDParser() throws JDOMException {
        XMLReader xMLReader;
        block13: {
            xMLReader = null;
            try {
                xMLReader = this.createParser();
            }
            catch (Exception exception) {
                throw new JDOMException("Error in SAX parser allocation", exception);
            }
            if (this.getDTDHandler() != null) {
                xMLReader.setDTDHandler(this.getDTDHandler());
            }
            if (this.getEntityResolver() != null) {
                xMLReader.setEntityResolver(this.getEntityResolver());
            }
            if (this.getLexicalHandler() != null) {
                try {
                    xMLReader.setProperty(LEXICAL_HANDLER_SAX_PROPERTY, this.getLexicalHandler());
                }
                catch (SAXException sAXException) {
                    try {
                        xMLReader.setProperty(LEXICAL_HANDLER_ALT_PROPERTY, this.getLexicalHandler());
                    }
                    catch (SAXException sAXException2) {}
                }
            }
            if (this.getDeclHandler() == null) break block13;
            try {
                xMLReader.setProperty(DECL_HANDLER_SAX_PROPERTY, this.getDeclHandler());
            }
            catch (SAXException sAXException) {
                try {
                    xMLReader.setProperty(DECL_HANDLER_ALT_PROPERTY, this.getDeclHandler());
                }
                catch (SAXException sAXException3) {}
            }
        }
        return xMLReader;
    }

    protected XMLReader createParser() throws Exception {
        XMLReader xMLReader = null;
        try {
            Class<?> clazz = Class.forName("javax.xml.parsers.SAXParserFactory");
            Method method = clazz.getMethod("newInstance", null);
            Object object = method.invoke(null, null);
            Method method2 = clazz.getMethod("newSAXParser", null);
            Object object2 = method2.invoke(object, null);
            Class<?> clazz2 = object2.getClass();
            Method method3 = clazz2.getMethod("getXMLReader", null);
            xMLReader = (XMLReader)method3.invoke(object2, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        if (xMLReader == null) {
            xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        }
        return xMLReader;
    }

    private void documentLocator(Document document) {
        LocatorImpl locatorImpl = new LocatorImpl();
        String string = null;
        String string2 = null;
        DocType docType = document.getDocType();
        if (docType != null) {
            string = docType.getPublicID();
            string2 = docType.getSystemID();
        }
        locatorImpl.setPublicId(string);
        locatorImpl.setSystemId(string2);
        locatorImpl.setLineNumber(-1);
        locatorImpl.setColumnNumber(-1);
        this.contentHandler.setDocumentLocator(locatorImpl);
    }

    private void dtdEvents(Document document) throws JDOMException {
        DocType docType = document.getDocType();
        if (docType != null && (this.dtdHandler != null || this.declHandler != null)) {
            String string = docType.getPublicID();
            String string2 = docType.getSystemID();
            String string3 = docType.getInternalSubset();
            if (string3 != null) {
                string3 = string3.trim();
            }
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("<!DOCTYPE ").append(docType.getElementName());
            if (string3 != null && string3.length() != 0) {
                stringBuffer.append(" [\n").append(string3).append(']');
            } else if (string != null || string2 != null) {
                if (string != null) {
                    stringBuffer.append(" PUBLIC ");
                    stringBuffer.append('\"').append(string).append('\"');
                } else {
                    stringBuffer.append(" SYSTEM ");
                }
                stringBuffer.append('\"').append(string2).append('\"');
            } else {
                stringBuffer.setLength(0);
            }
            if (stringBuffer.length() != 0) {
                try {
                    String string4 = stringBuffer.append('>').toString();
                    this.createDTDParser().parse(new InputSource(new StringReader(string4)));
                }
                catch (SAXParseException sAXParseException) {
                }
                catch (SAXException sAXException) {
                    throw new JDOMException("DTD parsing error", sAXException);
                }
                catch (IOException iOException) {
                    throw new JDOMException("DTD parsing error", iOException);
                }
            }
        }
    }

    private void element(Element element, NamespaceStack namespaceStack) throws JDOMException {
        int n = namespaceStack.size();
        Attributes attributes = this.startPrefixMapping(element, namespaceStack);
        this.startElement(element, attributes);
        this.elementContent(element, namespaceStack);
        this.endElement(element);
        this.endPrefixMapping(namespaceStack, n);
    }

    private void elementContent(Element element, NamespaceStack namespaceStack) throws JDOMException {
        boolean bl;
        List list = element.getContent();
        boolean bl2 = list.size() == 0;
        boolean bl3 = bl = !bl2 && list.size() == 1 && list.get(0) instanceof Text;
        if (bl) {
            this.characters(element.getText());
        } else {
            Object var6_6 = null;
            int n = 0;
            int n2 = list.size();
            while (n < n2) {
                var6_6 = list.get(n);
                if (var6_6 instanceof Element) {
                    this.element(var6_6, namespaceStack);
                } else if (var6_6 instanceof Text) {
                    this.characters(((Text)var6_6).getText());
                } else if (var6_6 instanceof CDATA) {
                    this.characters(((CDATA)var6_6).getText());
                } else if (var6_6 instanceof ProcessingInstruction) {
                    this.processingInstruction(var6_6);
                }
                ++n;
            }
        }
    }

    private void endDocument() throws JDOMException {
        try {
            this.contentHandler.endDocument();
        }
        catch (SAXException sAXException) {
            throw new JDOMException("Exception in endDocument", sAXException);
        }
    }

    private void endElement(Element element) throws JDOMException {
        String string = element.getNamespaceURI();
        String string2 = element.getName();
        String string3 = element.getQualifiedName();
        try {
            this.contentHandler.endElement(string, string2, string3);
        }
        catch (SAXException sAXException) {
            throw new JDOMException("Exception in endElement", sAXException);
        }
    }

    private void endPrefixMapping(NamespaceStack namespaceStack, int n) throws JDOMException {
        while (namespaceStack.size() > n) {
            String string = namespaceStack.pop();
            try {
                this.contentHandler.endPrefixMapping(string);
            }
            catch (SAXException sAXException) {
                throw new JDOMException("Exception in endPrefixMapping", sAXException);
            }
        }
    }

    private String getAttributeTypeName(int n) {
        if (n < 0 || n >= attrTypeToNameMap.length) {
            n = 0;
        }
        return attrTypeToNameMap[n];
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public DeclHandler getDeclHandler() {
        return this.declHandler;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (NS_PREFIXES_SAX_FEATURE.equals(string)) {
            return this.declareNamespaces;
        }
        if (NAMESPACES_SAX_FEATURE.equals(string)) {
            return true;
        }
        throw new SAXNotRecognizedException(string);
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (LEXICAL_HANDLER_SAX_PROPERTY.equals(string) || LEXICAL_HANDLER_ALT_PROPERTY.equals(string)) {
            return this.getLexicalHandler();
        }
        if (DECL_HANDLER_SAX_PROPERTY.equals(string) || DECL_HANDLER_ALT_PROPERTY.equals(string)) {
            return this.getDeclHandler();
        }
        throw new SAXNotRecognizedException(string);
    }

    public void output(Document document) throws JDOMException {
        if (document == null) {
            return;
        }
        this.documentLocator(document);
        this.startDocument();
        this.dtdEvents(document);
        Iterator iterator = document.getContent().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Element) {
                this.element(document.getRootElement(), new NamespaceStack());
                continue;
            }
            if (e instanceof ProcessingInstruction) {
                this.processingInstruction((ProcessingInstruction)e);
                continue;
            }
            if (e instanceof CDATA) {
                this.characters(((CDATA)e).getText());
                continue;
            }
            if (!(e instanceof Comment)) continue;
            this.comment(((Comment)e).getText());
        }
        this.endDocument();
    }

    private void processingInstruction(ProcessingInstruction processingInstruction) throws JDOMException {
        if (processingInstruction != null) {
            String string = processingInstruction.getTarget();
            String string2 = processingInstruction.getData();
            try {
                this.contentHandler.processingInstruction(string, string2);
            }
            catch (SAXException sAXException) {
                throw new JDOMException("Exception in processingInstruction", sAXException);
            }
        }
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    public void setDeclHandler(DeclHandler declHandler) {
        this.declHandler = declHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (NS_PREFIXES_SAX_FEATURE.equals(string)) {
            this.setReportNamespaceDeclarations(bl);
        } else if (NAMESPACES_SAX_FEATURE.equals(string)) {
            if (!bl) {
                throw new SAXNotSupportedException(string);
            }
        } else {
            throw new SAXNotRecognizedException(string);
        }
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (LEXICAL_HANDLER_SAX_PROPERTY.equals(string) || LEXICAL_HANDLER_ALT_PROPERTY.equals(string)) {
            this.setLexicalHandler((LexicalHandler)object);
        } else if (DECL_HANDLER_SAX_PROPERTY.equals(string) || DECL_HANDLER_ALT_PROPERTY.equals(string)) {
            this.setDeclHandler((DeclHandler)object);
        } else {
            throw new SAXNotRecognizedException(string);
        }
    }

    public void setReportNamespaceDeclarations(boolean bl) {
        this.declareNamespaces = bl;
    }

    private void startDocument() throws JDOMException {
        try {
            this.contentHandler.startDocument();
        }
        catch (SAXException sAXException) {
            throw new JDOMException("Exception in startDocument", sAXException);
        }
    }

    private void startElement(Element element, Attributes attributes) throws JDOMException {
        String string = element.getNamespaceURI();
        String string2 = element.getName();
        String string3 = element.getQualifiedName();
        AttributesImpl attributesImpl = attributes != null ? new AttributesImpl(attributes) : new AttributesImpl();
        List list = element.getAttributes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            attributesImpl.addAttribute(attribute.getNamespaceURI(), attribute.getName(), attribute.getQualifiedName(), this.getAttributeTypeName(attribute.getAttributeType()), attribute.getValue());
        }
        try {
            this.contentHandler.startElement(string, string2, string3, attributesImpl);
        }
        catch (SAXException sAXException) {
            throw new JDOMException("Exception in startElement", sAXException);
        }
    }

    private Attributes startPrefixMapping(Element element, NamespaceStack namespaceStack) throws JDOMException {
        Object object;
        Object object2;
        AttributesImpl attributesImpl = null;
        Namespace namespace = element.getNamespace();
        if (namespace != Namespace.NO_NAMESPACE && namespace != Namespace.XML_NAMESPACE) {
            object2 = namespace.getPrefix();
            object = namespaceStack.getURI((String)object2);
            if (!namespace.getURI().equals(object)) {
                namespaceStack.push(namespace);
                attributesImpl = this.addNsAttribute(attributesImpl, namespace);
                try {
                    this.contentHandler.startPrefixMapping((String)object2, namespace.getURI());
                }
                catch (SAXException sAXException) {
                    throw new JDOMException("Exception in startPrefixMapping", sAXException);
                }
            }
        }
        if ((object2 = element.getAdditionalNamespaces()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                namespace = (Namespace)object.next();
                String string = namespace.getPrefix();
                String string2 = namespaceStack.getURI(string);
                if (namespace.getURI().equals(string2)) continue;
                namespaceStack.push(namespace);
                attributesImpl = this.addNsAttribute(attributesImpl, namespace);
                try {
                    this.contentHandler.startPrefixMapping(string, namespace.getURI());
                }
                catch (SAXException sAXException) {
                    throw new JDOMException("Exception in startPrefixMapping", sAXException);
                }
            }
        }
        return attributesImpl;
    }
}

