/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.printer.BlockStatementPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class WhilePrinter
extends BlockStatementPrinter {
    private static final Printer INSTANCE = new WhilePrinter();

    protected WhilePrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        super.print(node, out);
        int offset = 1;
        offset = settings.getBoolean(ConventionKeys.SPACE_BEFORE_STATEMENT_PAREN, true) ? out.print("while ", 95) : out.print("while", 95);
        this.trackPosition((JavaNode)node, out.line, offset, out);
        boolean insertBraces = settings.getBoolean(ConventionKeys.BRACE_INSERT_WHILE, false);
        AST lparen = node.getFirstChild();
        JavaNode rparen = this.printExpressionList(lparen, insertBraces, out);
        AST body = rparen.getNextSibling();
        switch (body.getType()) {
            case 11: {
                out.last = 95;
                PrinterFactory.create(body).print(body, out);
                break;
            }
            default: {
                if (insertBraces) {
                    out.printLeftBrace(settings.getBoolean(ConventionKeys.BRACE_NEWLINE_LEFT, false), true);
                    PrinterFactory.create(body).print(body, out);
                    out.printRightBrace();
                    break;
                }
                out.printNewline();
                out.indent();
                PrinterFactory.create(body).print(body, out);
                out.unindent();
            }
        }
        out.last = 8;
    }
}

