/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.swing.AbstractSettingsPage;
import de.hunsicker.jalopy.swing.ComboBoxPanel;
import de.hunsicker.jalopy.swing.LocationDialog;
import de.hunsicker.jalopy.swing.SettingsContainer;
import de.hunsicker.swing.ErrorDialog;
import de.hunsicker.swing.util.SwingHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class GeneralSettingsPage
extends AbstractSettingsPage {
    private static final String JDK_1_3 = "JDK 1.3";
    private static final String JDK_1_4 = "JDK 1.4";
    private static final String FILENAME_IMPORT = "import.dat";
    private static final String FILENAME_EXPORT = "export.dat";
    private final FileFilter FILTER_JAL = new JalopyFilter();
    private final FileFilter FILTER_XML = new XmlFilter();
    private JComboBox _compatComboBox;
    private JTextField _descTextField;
    private JTextField _nameTextField;

    public GeneralSettingsPage() {
        this.initialize();
    }

    GeneralSettingsPage(SettingsContainer container) {
        super(container);
        this.initialize();
    }

    public void updateSettings() {
        this.settings.put(ConventionKeys.CONVENTION_NAME, this._nameTextField.getText());
        this.settings.put(ConventionKeys.CONVENTION_DESCRIPTION, this._descTextField.getText());
        this.settings.putInt(ConventionKeys.SOURCE_VERSION, this.getSourceVersion((String)this._compatComboBox.getSelectedItem()));
    }

    private int getSourceVersion(String version) {
        if (JDK_1_3.equals(version)) {
            return 13;
        }
        if (JDK_1_4.equals(version)) {
            return 14;
        }
        return 14;
    }

    private String getSourceVersion(int version) {
        switch (version) {
            case 13: {
                return JDK_1_3;
            }
        }
        return JDK_1_4;
    }

    private JPanel createGeneralPane() {
        JPanel conventionPanel = new JPanel();
        conventionPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_CONVENTION")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagLayout conventionLayout = new GridBagLayout();
        conventionPanel.setLayout(conventionLayout);
        GridBagConstraints c = new GridBagConstraints();
        c.insets.right = 10;
        JLabel nameLbl = new JLabel(this.bundle.getString("LBL_NAME"));
        SwingHelper.setConstraints(c, 0, 0, -1, 1, 0.0, 0.0, 17, 2, c.insets, 0, 0);
        conventionLayout.setConstraints(nameLbl, c);
        conventionPanel.add((Component)nameLbl, c);
        this._nameTextField = new JTextField(this.settings.get(ConventionKeys.CONVENTION_NAME, "Sun"), 15);
        c.insets.right = 0;
        SwingHelper.setConstraints(c, 1, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        conventionLayout.setConstraints(this._nameTextField, c);
        conventionPanel.add(this._nameTextField);
        JLabel descLbl = new JLabel(this.bundle.getString("LBL_DESCRIPTION"));
        c.insets.right = 10;
        c.insets.top = 1;
        SwingHelper.setConstraints(c, 0, 1, -1, 1, 0.0, 0.0, 17, 2, c.insets, 0, 0);
        conventionLayout.setConstraints(descLbl, c);
        conventionPanel.add(descLbl);
        this._descTextField = new JTextField(this.settings.get(ConventionKeys.CONVENTION_DESCRIPTION, "Sun Java Coding Convention"), 15);
        c.insets.right = 0;
        SwingHelper.setConstraints(c, 1, 1, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        conventionLayout.setConstraints(this._descTextField, c);
        conventionPanel.add(this._descTextField);
        JPanel compatPanel = new JPanel();
        compatPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_COMPLIANCE")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagLayout compatLayout = new GridBagLayout();
        compatPanel.setLayout(compatLayout);
        int version = this.settings.getInt(ConventionKeys.SOURCE_VERSION, 14);
        Object[] items = new String[]{JDK_1_3, JDK_1_4};
        ComboBoxPanel compatComboBoxPanel = new ComboBoxPanel(this.bundle.getString("LBL_COMPATIBILITY"), items, this.getSourceVersion(version));
        c.insets.left = 0;
        c.insets.top = 0;
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 1.0, 17, 2, c.insets, 0, 0);
        compatLayout.setConstraints(compatComboBoxPanel, c);
        compatPanel.add((Component)compatComboBoxPanel, c);
        this._compatComboBox = compatComboBoxPanel.getComboBox();
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(conventionPanel, c);
        panel.add(conventionPanel);
        c.insets.top = 10;
        c.insets.bottom = 10;
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 0.0, 1.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(compatPanel, c);
        panel.add(compatPanel);
        return panel;
    }

    private JPanel createImportExportPane() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 5, 5));
        JButton importButton = SwingHelper.createButton(this.bundle.getString("BTN_IMPORT"), true);
        importButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                Window owner = SwingUtilities.windowForComponent(GeneralSettingsPage.this);
                LocationDialog dialog = LocationDialog.create(owner, GeneralSettingsPage.this.bundle.getString("TLE_IMPORT_CODE_CONVENTION"), "XXX", LocationDialog.loadHistory(new File(Convention.getProjectSettingsDirectory(), GeneralSettingsPage.FILENAME_IMPORT)));
                dialog.addFilter(GeneralSettingsPage.this.FILTER_JAL);
                dialog.addFilter(GeneralSettingsPage.this.FILTER_XML, true);
                dialog.setVisible(true);
                switch (dialog.getOption()) {
                    case 0: {
                        try {
                            String location = (String)dialog.getSelectedLocation();
                            if (location == null || location.trim().length() == 0) {
                                return;
                            }
                            FileFilter filter = dialog.getFileFilter();
                            if (filter == GeneralSettingsPage.this.FILTER_JAL || location.endsWith(".jal")) {
                                if (!location.endsWith(".jal")) {
                                    location = location + ".jal";
                                }
                            } else if ((filter == GeneralSettingsPage.this.FILTER_XML || location.endsWith(".xml")) && !location.endsWith(".xml")) {
                                location = location + ".xml";
                            }
                            if (location.startsWith("http:")) {
                                Convention cfr_ignored_0 = GeneralSettingsPage.this.settings;
                                Convention.importSettings(new URL(location));
                                GeneralSettingsPage.this.settings.put(ConventionKeys.STYLE_LOCATION, location);
                            } else if (location.startsWith("www.")) {
                                Convention cfr_ignored_1 = GeneralSettingsPage.this.settings;
                                Convention.importSettings(new URL("http://" + location));
                                GeneralSettingsPage.this.settings.put(ConventionKeys.STYLE_LOCATION, "http://" + location);
                            } else {
                                Convention cfr_ignored_2 = GeneralSettingsPage.this.settings;
                                Convention.importSettings(new File(location));
                            }
                            GeneralSettingsPage.this._nameTextField.setText(GeneralSettingsPage.this.settings.get(ConventionKeys.CONVENTION_NAME, "Sun"));
                            GeneralSettingsPage.this._descTextField.setText(GeneralSettingsPage.this.settings.get(ConventionKeys.CONVENTION_DESCRIPTION, "Sun Java Coding Convention"));
                            int version = GeneralSettingsPage.this.settings.getInt(ConventionKeys.SOURCE_VERSION, 14);
                            GeneralSettingsPage.this._compatComboBox.setSelectedItem(GeneralSettingsPage.this.getSourceVersion(version));
                            LocationDialog.storeHistory(new File(Convention.getProjectSettingsDirectory(), GeneralSettingsPage.FILENAME_IMPORT), dialog.getHistoryString());
                            if (GeneralSettingsPage.this.getContainer() != null) {
                                GeneralSettingsPage.this.getContainer().clearCache();
                            }
                            GeneralSettingsPage.this.settings.flush();
                            dialog.dispose();
                            break;
                        }
                        catch (Exception ex) {
                            ErrorDialog d = ErrorDialog.create(owner, ex);
                            d.setVisible(true);
                            d.dispose();
                        }
                    }
                }
            }
        });
        JButton exportButton = SwingHelper.createButton(this.bundle.getString("BTN_EXPORT"));
        exportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                Window owner = SwingUtilities.windowForComponent(GeneralSettingsPage.this);
                LocationDialog dialog = LocationDialog.create(owner, GeneralSettingsPage.this.bundle.getString("TLE_EXPORT_CODE_CONVENTION"), "XXX", LocationDialog.loadHistory(new File(Convention.getProjectSettingsDirectory(), GeneralSettingsPage.FILENAME_EXPORT)));
                dialog.addFilter(GeneralSettingsPage.this.FILTER_XML, true);
                dialog.setVisible(true);
                switch (dialog.getOption()) {
                    case 0: {
                        String location = (String)dialog.getSelectedLocation();
                        if (location != null && location.length() > 0) {
                            try {
                                LocationDialog.storeHistory(new File(Convention.getProjectSettingsDirectory(), GeneralSettingsPage.FILENAME_EXPORT), dialog.getHistoryString());
                                String extension = ".xml";
                                if (!location.endsWith(".xml")) {
                                    location = location + ".xml";
                                }
                                FileOutputStream out = new FileOutputStream(new File(location));
                                GeneralSettingsPage.this.settings.exportSettings(out, extension);
                            }
                            catch (Exception ex) {
                                ErrorDialog d = ErrorDialog.create(owner, ex);
                                d.setVisible(true);
                                d.dispose();
                            }
                        }
                        dialog.dispose();
                    }
                }
            }
        });
        buttonPanel.add(importButton);
        buttonPanel.add(exportButton);
        return buttonPanel;
    }

    private void initialize() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.insets.top = 10;
        JPanel conventionPanel = this.createGeneralPane();
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(conventionPanel, c);
        this.add(conventionPanel);
        JPanel importExportPanel = this.createImportExportPane();
        c.insets.bottom = 10;
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 1.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(importExportPanel, c);
        this.add(importExportPanel);
    }

    private final class XmlFilter
    extends FileFilter {
        private XmlFilter() {
        }

        public String getDescription() {
            return GeneralSettingsPage.this.bundle.getString("LBL_XML_CONVENTION");
        }

        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().endsWith(".xml");
        }
    }

    private final class JalopyFilter
    extends FileFilter {
        private JalopyFilter() {
        }

        public String getDescription() {
            return GeneralSettingsPage.this.bundle.getString("LBL_BINARY_CONVENTION");
        }

        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().endsWith(".jal");
        }
    }

    private static class AddDialog
    extends JDialog {
        String value;

        public AddDialog(Frame owner, String title, String text) {
            super(owner);
            this.initialize(title, text);
        }

        public AddDialog(Dialog owner, String title, String text) {
            super(owner);
            this.initialize(title, text);
        }

        private void initialize(String title, String text) {
            this.setTitle(title);
            this.setModal(true);
            this.setDefaultCloseOperation(2);
            Container contentPane = this.getContentPane();
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            contentPane.setLayout(layout);
            JLabel valueLabel = new JLabel(text);
            c.insets.top = 10;
            c.insets.left = 5;
            c.insets.right = 5;
            SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
            layout.setConstraints(valueLabel, c);
            contentPane.add(valueLabel);
            JTextField valueTextField = new JTextField(20);
            valueLabel.setLabelFor(valueTextField);
            c.insets.top = 2;
            SwingHelper.setConstraints(c, 0, 1, 12, 1, 1.0, 1.0, 17, 2, c.insets, 0, 0);
            layout.setConstraints(valueTextField, c);
            contentPane.add(valueTextField);
            ResourceBundle bundle = ResourceBundle.getBundle("de.hunsicker.jalopy.swing.Bundle");
            JButton cancelButton = SwingHelper.createButton(bundle.getString("BTN_CANCEL"));
            cancelButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ AddDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$0.setVisible(false);
                    this.this$0.dispose();
                }
            });
            JButton okButton = SwingHelper.createButton(bundle.getString("BTN_OK"));
            okButton.addActionListener(new ActionListener(this, valueTextField){
                private final /* synthetic */ JTextField val$valueTextField;
                private final /* synthetic */ AddDialog this$0;
                {
                    this.this$0 = this$0;
                    this.val$valueTextField = val$valueTextField;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$0.setVisible(false);
                    String contents = this.val$valueTextField.getText();
                    if (contents.length() == 0) {
                        return;
                    }
                    this.this$0.value = contents;
                    this.this$0.dispose();
                }
            });
            this.getRootPane().setDefaultButton(okButton);
            c.insets.top = 15;
            c.insets.bottom = 5;
            SwingHelper.setConstraints(c, 9, 2, 1, 1, 1.0, 0.0, 13, 0, c.insets, 0, 0);
            layout.setConstraints(okButton, c);
            contentPane.add(okButton);
            c.insets.left = 0;
            SwingHelper.setConstraints(c, 11, 2, 0, 1, 0.0, 0.0, 17, 0, c.insets, 0, 0);
            layout.setConstraints(cancelButton, c);
            contentPane.add(cancelButton);
        }
    }
}

