/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.swing.AbstractSettingsPage;
import de.hunsicker.jalopy.swing.AddRemoveList;
import de.hunsicker.jalopy.swing.NumberComboBoxPanel;
import de.hunsicker.jalopy.swing.SettingsContainer;
import de.hunsicker.jalopy.swing.ValidationException;
import de.hunsicker.swing.util.SwingHelper;
import de.hunsicker.util.StringHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class HeaderSettingsPage
extends AbstractSettingsPage {
    private static final String LINE_SEPARATOR = "\n";
    private static final String EMPTY_STRING = "".intern();
    private AddRemoveList _keysList;
    private JButton _addButton;
    private JButton _removeButton;
    private JCheckBox _useCheckBox;
    private JComboBox _blankLinesAfterComboBox;
    private JComboBox _blankLinesBeforeComboBox;
    private JComboBox _smartModeComboBox;
    private JTabbedPane _tabs;
    private JTextArea _textTextArea;
    private NumberComboBoxPanel _blankLinesAfterComboBoxPnl;
    private NumberComboBoxPanel _blankLinesBeforeComboBoxPnl;

    public HeaderSettingsPage() {
        this.initialize();
    }

    HeaderSettingsPage(SettingsContainer container) {
        super(container);
        this.initialize();
    }

    public void updateSettings() {
        this.settings.put(this.getBlankLinesBeforeKey(), (String)this._blankLinesBeforeComboBox.getSelectedItem());
        this.settings.put(this.getBlankLinesAfterKey(), (String)this._blankLinesAfterComboBox.getSelectedItem());
        this.settings.putBoolean(this.getUseKey(), this._useCheckBox.isSelected());
        this.settings.put(this.getSmartModeKey(), (String)this._smartModeComboBox.getSelectedItem());
        this.storeText();
        DefaultListModel keysListModel = (DefaultListModel)this._keysList.getModel();
        if (keysListModel.size() > 0) {
            Object[] items = new String[keysListModel.size()];
            keysListModel.copyInto(items);
            StringBuffer buf = new StringBuffer(100);
            for (int i = 0; i < items.length; ++i) {
                buf.append((String)items[i]);
                buf.append("|");
            }
            buf.deleteCharAt(buf.length() - 1);
            this.settings.put(this.getConventionKeysKey(), buf.toString());
        } else {
            this.settings.put(this.getConventionKeysKey(), EMPTY_STRING);
        }
    }

    public void validateSettings() throws ValidationException {
        DefaultListModel keysListModel = (DefaultListModel)this._keysList.getModel();
        if (!this.isSmartModeEnabled() && this._useCheckBox.isSelected() && keysListModel.size() == 0) {
            Object[] args = new Object[]{this.getDeleteLabel()};
            JOptionPane.showMessageDialog(this, MessageFormat.format(this.bundle.getString("MSG_MISSING_IDENTIFY_KEY"), args), this.bundle.getString("TLE_MISSING_IDENTIFY_KEY"), 0);
            throw new ValidationException();
        }
    }

    protected Convention.Key getBlankLinesAfterKey() {
        return ConventionKeys.BLANK_LINES_AFTER_HEADER;
    }

    protected Convention.Key getBlankLinesBeforeKey() {
        return ConventionKeys.BLANK_LINES_BEFORE_HEADER;
    }

    protected Convention.Key getConventionKeysKey() {
        return ConventionKeys.HEADER_KEYS;
    }

    protected String getDefaultAfter() {
        return String.valueOf(0);
    }

    protected String getDeleteLabel() {
        return this.bundle.getString("BDR_DELETE_HEADERS");
    }

    protected String[] getItemsAfter() {
        return this.createItemList(new int[]{0, 1, 2, 3, 4, 5});
    }

    protected Convention.Key getSmartModeKey() {
        return ConventionKeys.HEADER_SMART_MODE_LINES;
    }

    protected Convention.Key getTextKey() {
        return ConventionKeys.HEADER_TEXT;
    }

    protected Convention.Key getUseKey() {
        return ConventionKeys.HEADER;
    }

    protected String getUseLabel() {
        return this.bundle.getString("CHK_USE_HEADER");
    }

    private boolean isSmartModeEnabled() {
        try {
            return Integer.parseInt((String)this._smartModeComboBox.getSelectedItem()) > 0;
        }
        catch (NumberFormatException neverOccurs) {
            return false;
        }
    }

    private void initialize() {
        this._textTextArea = new JTextArea(this.loadText(), 7, 50);
        this._textTextArea.setFont(new Font("Monospaced", 0, 12));
        this._textTextArea.setForeground(new Color(0, 128, 128));
        this._textTextArea.setCaretPosition(0);
        JScrollPane textScroller = new JScrollPane(this._textTextArea);
        JPanel textPanel = new JPanel();
        textPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        textPanel.setLayout(new BorderLayout());
        textPanel.setAlignmentX(0.0f);
        textPanel.add(textScroller);
        JPanel headerPanel = new JPanel();
        GridBagLayout headerLayout = new GridBagLayout();
        headerPanel.setLayout(headerLayout);
        headerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_GENERAL")), BorderFactory.createEmptyBorder(0, 5, 5, 0)));
        GridBagConstraints c = new GridBagConstraints();
        this._useCheckBox = new JCheckBox(this.getUseLabel(), this.settings.getBoolean(this.getUseKey(), false));
        this._useCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 0, 1, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        headerLayout.setConstraints(this._useCheckBox, c);
        headerPanel.add(this._useCheckBox);
        int lines = this.settings.getInt(this.getSmartModeKey(), 0);
        Object[] lineItems = this.createItemList(new int[]{0, 5, 10, 15, 20});
        NumberComboBoxPanel smartModeComboBoxPanel = new NumberComboBoxPanel(this.bundle.getString("LBL_SMART_MODE"), lineItems, String.valueOf(lines));
        SwingHelper.setConstraints(c, 1, 0, 0, 1, 0.0, 0.0, 13, 0, c.insets, 0, 0);
        headerLayout.setConstraints(smartModeComboBoxPanel, c);
        headerPanel.add(smartModeComboBoxPanel);
        this._smartModeComboBox = smartModeComboBoxPanel.getComboBox();
        JPanel blankLinesPanel = new JPanel();
        blankLinesPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_BLANK_LINES")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagLayout blankLinesLayout = new GridBagLayout();
        blankLinesPanel.setLayout(blankLinesLayout);
        Object[] items = this.createItemList(new int[]{0, 1, 2, 3, 4, 5});
        this._blankLinesBeforeComboBoxPnl = new NumberComboBoxPanel(this.bundle.getString("LBL_BLANK_LINES_BEFORE"), items, this.settings.get(this.getBlankLinesBeforeKey(), "0"));
        this._blankLinesBeforeComboBox = this._blankLinesBeforeComboBoxPnl.getComboBox();
        this._blankLinesBeforeComboBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        blankLinesLayout.setConstraints(this._blankLinesBeforeComboBoxPnl, c);
        blankLinesPanel.add(this._blankLinesBeforeComboBoxPnl);
        this._blankLinesAfterComboBoxPnl = new NumberComboBoxPanel(this.bundle.getString("LBL_BLANK_LINES_AFTER"), this.getItemsAfter(), this.settings.get(this.getBlankLinesAfterKey(), this.getDefaultAfter()));
        this._blankLinesAfterComboBox = this._blankLinesAfterComboBoxPnl.getComboBox();
        this._blankLinesAfterComboBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        blankLinesLayout.setConstraints(this._blankLinesAfterComboBoxPnl, c);
        blankLinesPanel.add(this._blankLinesAfterComboBoxPnl);
        JPanel identifyPanel = new JPanel();
        identifyPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.getDeleteLabel()), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagLayout identifyLayout = new GridBagLayout();
        identifyPanel.setLayout(identifyLayout);
        String keysString = this.settings.get(this.getConventionKeysKey(), EMPTY_STRING);
        ArrayList<Object> keys = Collections.EMPTY_LIST;
        if (keysString != null && !keysString.trim().equals(EMPTY_STRING)) {
            keys = new ArrayList<Object>();
            StringTokenizer tokens = new StringTokenizer(keysString, "|");
            while (tokens.hasMoreElements()) {
                keys.add(tokens.nextElement());
            }
        }
        this._keysList = new AddRemoveList(this.bundle.getString("TLE_ADD_IDENTIFY_KEY"), this.bundle.getString("LBL_ADD_IDENTIFY_KEY"), keys);
        JScrollPane keysScrollPane = new JScrollPane(this._keysList);
        SwingHelper.setConstraints(c, 0, 0, 8, 8, 1.0, 1.0, 17, 1, c.insets, 0, 0);
        identifyLayout.setConstraints(keysScrollPane, c);
        identifyPanel.add(keysScrollPane);
        c.insets.bottom = 2;
        c.insets.top = 10;
        c.insets.left = 10;
        c.insets.right = 0;
        SwingHelper.setConstraints(c, 9, 1, 0, 1, 0.0, 0.0, 18, 2, c.insets, 0, 0);
        this._addButton = this._keysList.getAddButton();
        identifyLayout.setConstraints(this._addButton, c);
        identifyPanel.add(this._addButton);
        c.insets.left = 10;
        c.insets.right = 0;
        c.insets.bottom = 0;
        c.insets.top = 0;
        SwingHelper.setConstraints(c, 9, 2, 0, 1, 0.0, 1.0, 18, 2, c.insets, 0, 0);
        this._removeButton = this._keysList.getRemoveButton();
        this._removeButton.setEnabled(false);
        identifyLayout.setConstraints(this._removeButton, c);
        identifyPanel.add(this._removeButton);
        JPanel panels = new JPanel();
        GridBagLayout panelsLayout = new GridBagLayout();
        panels.setLayout(panelsLayout);
        c.insets.top = 10;
        c.insets.left = 5;
        c.insets.right = 5;
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        panelsLayout.setConstraints(headerPanel, c);
        panels.add(headerPanel);
        c.insets.bottom = 10;
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        panelsLayout.setConstraints(blankLinesPanel, c);
        panels.add(blankLinesPanel);
        c.insets.top = 0;
        SwingHelper.setConstraints(c, 0, 2, 0, 1, 1.0, 1.0, 18, 1, c.insets, 0, 0);
        panelsLayout.setConstraints(identifyPanel, c);
        panels.add(identifyPanel);
        this._tabs = new JTabbedPane();
        this._tabs.add((Component)panels, this.bundle.getString("TAB_OPTIONS"));
        this._tabs.add((Component)textPanel, this.bundle.getString("TAB_TEXT"));
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.add((Component)this._tabs, "Center");
    }

    private String loadText() {
        String text = this.settings.get(this.getTextKey(), EMPTY_STRING);
        return text.replace('|', '\n');
    }

    private void storeText() {
        String text = this._textTextArea.getText().trim();
        if (text.length() > 0) {
            String[] lines = StringHelper.split(text, LINE_SEPARATOR);
            StringBuffer buf = new StringBuffer(text.length());
            for (int i = 0; i < lines.length; ++i) {
                buf.append(StringHelper.trimTrailing(lines[i]));
                buf.append("|");
            }
            if (lines.length > 0) {
                buf.deleteCharAt(buf.length() - 1);
            }
            this.settings.put(this.getTextKey(), buf.toString());
        }
    }
}

