/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.antlr;

import de.hunsicker.antlr.ANTLRLexer;
import de.hunsicker.antlr.ActionElement;
import de.hunsicker.antlr.Alternative;
import de.hunsicker.antlr.AlternativeBlock;
import de.hunsicker.antlr.AlternativeElement;
import de.hunsicker.antlr.BlockContext;
import de.hunsicker.antlr.BlockEndElement;
import de.hunsicker.antlr.CharLiteralElement;
import de.hunsicker.antlr.CharRangeElement;
import de.hunsicker.antlr.CodeGenerator;
import de.hunsicker.antlr.CommonToken;
import de.hunsicker.antlr.DefineGrammarSymbols;
import de.hunsicker.antlr.ExceptionHandler;
import de.hunsicker.antlr.ExceptionSpec;
import de.hunsicker.antlr.Grammar;
import de.hunsicker.antlr.GrammarAtom;
import de.hunsicker.antlr.LLkAnalyzer;
import de.hunsicker.antlr.LexerGrammar;
import de.hunsicker.antlr.OneOrMoreBlock;
import de.hunsicker.antlr.RuleBlock;
import de.hunsicker.antlr.RuleEndElement;
import de.hunsicker.antlr.RuleRefElement;
import de.hunsicker.antlr.RuleSymbol;
import de.hunsicker.antlr.SemanticException;
import de.hunsicker.antlr.StringLiteralElement;
import de.hunsicker.antlr.StringUtils;
import de.hunsicker.antlr.SynPredBlock;
import de.hunsicker.antlr.Token;
import de.hunsicker.antlr.TokenRangeElement;
import de.hunsicker.antlr.TokenRefElement;
import de.hunsicker.antlr.TokenSymbol;
import de.hunsicker.antlr.Tool;
import de.hunsicker.antlr.TreeBlockContext;
import de.hunsicker.antlr.TreeElement;
import de.hunsicker.antlr.TreeWalkerGrammar;
import de.hunsicker.antlr.WildcardElement;
import de.hunsicker.antlr.ZeroOrMoreBlock;
import de.hunsicker.antlr.collections.Stack;
import de.hunsicker.antlr.collections.impl.LList;
import de.hunsicker.antlr.collections.impl.Vector;

public class MakeGrammar
extends DefineGrammarSymbols {
    protected Stack blocks = new LList();
    protected RuleRefElement lastRuleRef;
    protected RuleEndElement ruleEnd;
    protected RuleBlock ruleBlock;
    protected int nested = 0;
    protected boolean grammarError = false;
    ExceptionSpec currentExceptionSpec = null;

    public MakeGrammar(Tool tool_, String[] args_, LLkAnalyzer analyzer_) {
        super(tool_, args_, analyzer_);
    }

    public void abortGrammar() {
        String s = "unknown grammar";
        if (this.grammar != null) {
            s = this.grammar.getClassName();
        }
        this.tool.error("aborting grammar '" + s + "' due to errors");
        super.abortGrammar();
    }

    protected void addElementToCurrentAlt(AlternativeElement e) {
        e.enclosingRuleName = this.ruleBlock.ruleName;
        this.context().addAlternativeElement(e);
    }

    public void beginAlt(boolean doAutoGen_) {
        super.beginAlt(doAutoGen_);
        Alternative alt = new Alternative();
        alt.setAutoGen(doAutoGen_);
        this.context().block.addAlternative(alt);
    }

    public void beginChildList() {
        super.beginChildList();
        this.context().block.addAlternative(new Alternative());
    }

    public void beginExceptionGroup() {
        super.beginExceptionGroup();
        if (!(this.context().block instanceof RuleBlock)) {
            this.tool.panic("beginExceptionGroup called outside of rule block");
        }
    }

    public void beginExceptionSpec(Token label) {
        if (label != null) {
            label.setText(StringUtils.stripFront(StringUtils.stripBack(label.getText(), " \n\r\t"), " \n\r\t"));
        }
        super.beginExceptionSpec(label);
        this.currentExceptionSpec = new ExceptionSpec(label);
    }

    public void beginSubRule(Token label, Token start, boolean not) {
        super.beginSubRule(label, start, not);
        this.blocks.push(new BlockContext());
        this.context().block = new AlternativeBlock(this.grammar, start, not);
        this.context().altNum = 0;
        ++this.nested;
        this.context().blockEnd = new BlockEndElement(this.grammar);
        this.context().blockEnd.block = this.context().block;
        this.labelElement(this.context().block, label);
    }

    public void beginTree(Token tok) throws SemanticException {
        if (!(this.grammar instanceof TreeWalkerGrammar)) {
            this.tool.error("Trees only allowed in TreeParser", this.grammar.getFilename(), tok.getLine(), tok.getColumn());
            throw new SemanticException("Trees only allowed in TreeParser");
        }
        super.beginTree(tok);
        this.blocks.push(new TreeBlockContext());
        this.context().block = new TreeElement(this.grammar, tok);
        this.context().altNum = 0;
    }

    public BlockContext context() {
        if (this.blocks.height() == 0) {
            return null;
        }
        return (BlockContext)this.blocks.top();
    }

    public static RuleBlock createNextTokenRule(Grammar g, Vector lexRules, String rname) {
        RuleBlock rb = new RuleBlock(g, rname);
        rb.setDefaultErrorHandler(g.getDefaultErrorHandler());
        RuleEndElement ruleEnd = new RuleEndElement(g);
        rb.setEndElement(ruleEnd);
        ruleEnd.block = rb;
        int i = 0;
        while (i < lexRules.size()) {
            RuleSymbol r = (RuleSymbol)lexRules.elementAt(i);
            if (!r.isDefined()) {
                g.antlrTool.error("Lexer rule " + r.id.substring(1) + " is not defined");
            } else if (r.access.equals("public")) {
                RuleRefElement rr = new RuleRefElement(g, new CommonToken(28, r.getId()), 1);
                rr.setLabel("theRetToken");
                rr.enclosingRuleName = "nextToken";
                rr.next = ruleEnd;
                Alternative alt = new Alternative(rr);
                alt.setAutoGen(true);
                rb.addAlternative(alt);
                r.addReference(rr);
            }
            ++i;
        }
        rb.setAutoGen(true);
        rb.prepareForAnalysis();
        return rb;
    }

    private AlternativeBlock createOptionalRuleRef(String rule, Token start) {
        AlternativeBlock blk = new AlternativeBlock(this.grammar, start, false);
        String mrule = CodeGenerator.encodeLexerRuleName(rule);
        if (!this.grammar.isDefined(mrule)) {
            this.grammar.define(new RuleSymbol(mrule));
        }
        CommonToken t = new CommonToken(24, rule);
        ((Token)t).setLine(start.getLine());
        ((Token)t).setLine(start.getColumn());
        RuleRefElement rref = new RuleRefElement(this.grammar, t, 1);
        rref.enclosingRuleName = this.ruleBlock.ruleName;
        BlockEndElement end = new BlockEndElement(this.grammar);
        end.block = blk;
        Alternative alt = new Alternative(rref);
        alt.addElement(end);
        blk.addAlternative(alt);
        Alternative optAlt = new Alternative();
        optAlt.addElement(end);
        blk.addAlternative(optAlt);
        blk.prepareForAnalysis();
        return blk;
    }

    public void defineRuleName(Token r, String access, boolean ruleAutoGen, String docComment) throws SemanticException {
        if (r.type == 24) {
            if (!(this.grammar instanceof LexerGrammar)) {
                this.tool.error("Lexical rule " + r.getText() + " defined outside of lexer", this.grammar.getFilename(), r.getLine(), r.getColumn());
                r.setText(r.getText().toLowerCase());
            }
        } else if (this.grammar instanceof LexerGrammar) {
            this.tool.error("Lexical rule names must be upper case, '" + r.getText() + "' is not", this.grammar.getFilename(), r.getLine(), r.getColumn());
            r.setText(r.getText().toUpperCase());
        }
        super.defineRuleName(r, access, ruleAutoGen, docComment);
        String id = r.getText();
        if (r.type == 24) {
            id = CodeGenerator.encodeLexerRuleName(id);
        }
        RuleSymbol rs = (RuleSymbol)this.grammar.getSymbol(id);
        RuleBlock rb = new RuleBlock(this.grammar, r.getText(), r.getLine(), ruleAutoGen);
        rb.setDefaultErrorHandler(this.grammar.getDefaultErrorHandler());
        this.ruleBlock = rb;
        this.blocks.push(new BlockContext());
        this.context().block = rb;
        rs.setBlock(rb);
        this.ruleEnd = new RuleEndElement(this.grammar);
        rb.setEndElement(this.ruleEnd);
        this.nested = 0;
    }

    public void endAlt() {
        super.endAlt();
        if (this.nested == 0) {
            this.addElementToCurrentAlt(this.ruleEnd);
        } else {
            this.addElementToCurrentAlt(this.context().blockEnd);
        }
        ++this.context().altNum;
    }

    public void endChildList() {
        super.endChildList();
        BlockEndElement be = new BlockEndElement(this.grammar);
        be.block = this.context().block;
        this.addElementToCurrentAlt(be);
    }

    public void endExceptionGroup() {
        super.endExceptionGroup();
    }

    public void endExceptionSpec() {
        super.endExceptionSpec();
        if (this.currentExceptionSpec == null) {
            this.tool.panic("exception processing internal error -- no active exception spec");
        }
        if (this.context().block instanceof RuleBlock) {
            ((RuleBlock)this.context().block).addExceptionSpec(this.currentExceptionSpec);
        } else if (this.context().currentAlt().exceptionSpec != null) {
            this.tool.error("Alternative already has an exception specification", this.grammar.getFilename(), this.context().block.getLine(), this.context().block.getColumn());
        } else {
            this.context().currentAlt().exceptionSpec = this.currentExceptionSpec;
        }
        this.currentExceptionSpec = null;
    }

    public void endGrammar() {
        if (this.grammarError) {
            this.abortGrammar();
        } else {
            super.endGrammar();
        }
    }

    public void endRule(String rule) {
        super.endRule(rule);
        BlockContext ctx = (BlockContext)this.blocks.pop();
        this.ruleEnd.block = ctx.block;
        this.ruleEnd.block.prepareForAnalysis();
    }

    public void endSubRule() {
        super.endSubRule();
        --this.nested;
        BlockContext ctx = (BlockContext)this.blocks.pop();
        AlternativeBlock block = ctx.block;
        if (!(!block.not || block instanceof SynPredBlock || block instanceof ZeroOrMoreBlock || block instanceof OneOrMoreBlock || this.analyzer.subruleCanBeInverted(block, this.grammar instanceof LexerGrammar))) {
            String newline = System.getProperty("line.separator");
            this.tool.error("This subrule cannot be inverted.  Only subrules of the form:" + newline + "    (T1|T2|T3...) or" + newline + "    ('c1'|'c2'|'c3'...)" + newline + "may be inverted (ranges are also allowed).", this.grammar.getFilename(), block.getLine(), block.getColumn());
        }
        if (block instanceof SynPredBlock) {
            SynPredBlock synpred = (SynPredBlock)block;
            this.context().block.hasASynPred = true;
            this.context().currentAlt().synPred = synpred;
            this.grammar.hasSyntacticPredicate = true;
            synpred.removeTrackingOfRuleRefs(this.grammar);
        } else {
            this.addElementToCurrentAlt(block);
        }
        ctx.blockEnd.block.prepareForAnalysis();
    }

    public void endTree() {
        super.endTree();
        BlockContext ctx = (BlockContext)this.blocks.pop();
        this.addElementToCurrentAlt(ctx.block);
    }

    public void hasError() {
        this.grammarError = true;
    }

    private void labelElement(AlternativeElement el, Token label) {
        if (label != null) {
            int i = 0;
            while (i < this.ruleBlock.labeledElements.size()) {
                AlternativeElement altEl = (AlternativeElement)this.ruleBlock.labeledElements.elementAt(i);
                String l = altEl.getLabel();
                if (l != null && l.equals(label.getText())) {
                    this.tool.error("Label '" + label.getText() + "' has already been defined", this.grammar.getFilename(), label.getLine(), label.getColumn());
                    return;
                }
                ++i;
            }
            el.setLabel(label.getText());
            this.ruleBlock.labeledElements.appendElement(el);
        }
    }

    public void noAutoGenSubRule() {
        this.context().block.setAutoGen(false);
    }

    public void oneOrMoreSubRule() {
        if (this.context().block.not) {
            this.tool.error("'~' cannot be applied to (...)* subrule", this.grammar.getFilename(), this.context().block.getLine(), this.context().block.getColumn());
        }
        OneOrMoreBlock b = new OneOrMoreBlock(this.grammar);
        MakeGrammar.setBlock(b, this.context().block);
        BlockContext old = (BlockContext)this.blocks.pop();
        this.blocks.push(new BlockContext());
        this.context().block = b;
        this.context().blockEnd = old.blockEnd;
        this.context().blockEnd.block = b;
    }

    public void optionalSubRule() {
        if (this.context().block.not) {
            this.tool.error("'~' cannot be applied to (...)? subrule", this.grammar.getFilename(), this.context().block.getLine(), this.context().block.getColumn());
        }
        this.beginAlt(false);
        this.endAlt();
    }

    public void refAction(Token action) {
        super.refAction(action);
        this.context().block.hasAnAction = true;
        this.addElementToCurrentAlt(new ActionElement(this.grammar, action));
    }

    public void setUserExceptions(String thr) {
        ((RuleBlock)this.context().block).throwsSpec = thr;
    }

    public void refArgAction(Token action) {
        ((RuleBlock)this.context().block).argAction = action.getText();
    }

    public void refCharLiteral(Token lit, Token label, boolean inverted, int autoGenType, boolean lastInRule) {
        if (!(this.grammar instanceof LexerGrammar)) {
            this.tool.error("Character literal only valid in lexer", this.grammar.getFilename(), lit.getLine(), lit.getColumn());
            return;
        }
        super.refCharLiteral(lit, label, inverted, autoGenType, lastInRule);
        CharLiteralElement cl = new CharLiteralElement((LexerGrammar)this.grammar, lit, inverted, autoGenType);
        if (!((LexerGrammar)this.grammar).caseSensitive && cl.getType() < 128 && Character.toLowerCase((char)cl.getType()) != (char)cl.getType()) {
            this.tool.warning("Character literal must be lowercase when caseSensitive=false", this.grammar.getFilename(), lit.getLine(), lit.getColumn());
        }
        this.addElementToCurrentAlt(cl);
        this.labelElement(cl, label);
        String ignore = this.ruleBlock.getIgnoreRule();
        if (!lastInRule && ignore != null) {
            this.addElementToCurrentAlt(this.createOptionalRuleRef(ignore, lit));
        }
    }

    public void refCharRange(Token t1, Token t2, Token label, int autoGenType, boolean lastInRule) {
        if (!(this.grammar instanceof LexerGrammar)) {
            this.tool.error("Character range only valid in lexer", this.grammar.getFilename(), t1.getLine(), t1.getColumn());
            return;
        }
        int rangeMin = ANTLRLexer.tokenTypeForCharLiteral(t1.getText());
        int rangeMax = ANTLRLexer.tokenTypeForCharLiteral(t2.getText());
        if (rangeMax < rangeMin) {
            this.tool.error("Malformed range.", this.grammar.getFilename(), t1.getLine(), t1.getColumn());
            return;
        }
        if (!((LexerGrammar)this.grammar).caseSensitive) {
            if (rangeMin < 128 && Character.toLowerCase((char)rangeMin) != (char)rangeMin) {
                this.tool.warning("Character literal must be lowercase when caseSensitive=false", this.grammar.getFilename(), t1.getLine(), t1.getColumn());
            }
            if (rangeMax < 128 && Character.toLowerCase((char)rangeMax) != (char)rangeMax) {
                this.tool.warning("Character literal must be lowercase when caseSensitive=false", this.grammar.getFilename(), t2.getLine(), t2.getColumn());
            }
        }
        super.refCharRange(t1, t2, label, autoGenType, lastInRule);
        CharRangeElement cr = new CharRangeElement((LexerGrammar)this.grammar, t1, t2, autoGenType);
        this.addElementToCurrentAlt(cr);
        this.labelElement(cr, label);
        String ignore = this.ruleBlock.getIgnoreRule();
        if (!lastInRule && ignore != null) {
            this.addElementToCurrentAlt(this.createOptionalRuleRef(ignore, t1));
        }
    }

    public void refTokensSpecElementOption(Token tok, Token option, Token value) {
        TokenSymbol ts = this.grammar.tokenManager.getTokenSymbol(tok.getText());
        if (ts == null) {
            this.tool.panic("cannot find " + tok.getText() + "in tokens {...}");
        }
        if (option.getText().equals("AST")) {
            ts.setASTNodeType(value.getText());
        } else {
            this.grammar.antlrTool.error("invalid tokens {...} element option:" + option.getText(), this.grammar.getFilename(), option.getLine(), option.getColumn());
        }
    }

    public void refElementOption(Token option, Token value) {
        AlternativeElement e = this.context().currentElement();
        if (e instanceof StringLiteralElement || e instanceof TokenRefElement || e instanceof WildcardElement) {
            ((GrammarAtom)e).setOption(option, value);
        } else {
            this.tool.error("cannot use element option (" + option.getText() + ") for this kind of element", this.grammar.getFilename(), option.getLine(), option.getColumn());
        }
    }

    public void refExceptionHandler(Token exTypeAndName, Token action) {
        super.refExceptionHandler(exTypeAndName, action);
        if (this.currentExceptionSpec == null) {
            this.tool.panic("exception handler processing internal error");
        }
        this.currentExceptionSpec.addHandler(new ExceptionHandler(exTypeAndName, action));
    }

    public void refInitAction(Token action) {
        super.refAction(action);
        this.context().block.setInitAction(action.getText());
    }

    public void refMemberAction(Token act) {
        this.grammar.classMemberAction = act;
    }

    public void refPreambleAction(Token act) {
        super.refPreambleAction(act);
    }

    public void refReturnAction(Token returnAction) {
        if (this.grammar instanceof LexerGrammar) {
            String name = CodeGenerator.encodeLexerRuleName(((RuleBlock)this.context().block).getRuleName());
            RuleSymbol rs = (RuleSymbol)this.grammar.getSymbol(name);
            if (rs.access.equals("public")) {
                this.tool.warning("public Lexical rules cannot specify return type", this.grammar.getFilename(), returnAction.getLine(), returnAction.getColumn());
                return;
            }
        }
        ((RuleBlock)this.context().block).returnAction = returnAction.getText();
    }

    public void refRule(Token idAssign, Token r, Token label, Token args, int autoGenType) {
        if (this.grammar instanceof LexerGrammar) {
            if (r.type != 24) {
                this.tool.error("Parser rule " + r.getText() + " referenced in lexer");
                return;
            }
            if (autoGenType == 2) {
                this.tool.error("AST specification ^ not allowed in lexer", this.grammar.getFilename(), r.getLine(), r.getColumn());
            }
        }
        super.refRule(idAssign, r, label, args, autoGenType);
        this.lastRuleRef = new RuleRefElement(this.grammar, r, autoGenType);
        if (args != null) {
            this.lastRuleRef.setArgs(args.getText());
        }
        if (idAssign != null) {
            this.lastRuleRef.setIdAssign(idAssign.getText());
        }
        this.addElementToCurrentAlt(this.lastRuleRef);
        String id = r.getText();
        if (r.type == 24) {
            id = CodeGenerator.encodeLexerRuleName(id);
        }
        RuleSymbol rs = (RuleSymbol)this.grammar.getSymbol(id);
        rs.addReference(this.lastRuleRef);
        this.labelElement(this.lastRuleRef, label);
    }

    public void refSemPred(Token pred) {
        super.refSemPred(pred);
        if (this.context().currentAlt().atStart()) {
            this.context().currentAlt().semPred = pred.getText();
        } else {
            ActionElement a = new ActionElement(this.grammar, pred);
            a.isSemPred = true;
            this.addElementToCurrentAlt(a);
        }
    }

    public void refStringLiteral(Token lit, Token label, int autoGenType, boolean lastInRule) {
        super.refStringLiteral(lit, label, autoGenType, lastInRule);
        if (this.grammar instanceof TreeWalkerGrammar && autoGenType == 2) {
            this.tool.error("^ not allowed in here for tree-walker", this.grammar.getFilename(), lit.getLine(), lit.getColumn());
        }
        StringLiteralElement sl = new StringLiteralElement(this.grammar, lit, autoGenType);
        if (this.grammar instanceof LexerGrammar && !((LexerGrammar)this.grammar).caseSensitive) {
            int i = 1;
            while (i < lit.getText().length() - 1) {
                char c = lit.getText().charAt(i);
                if (c < '\u0080' && Character.toLowerCase(c) != c) {
                    this.tool.warning("Characters of string literal must be lowercase when caseSensitive=false", this.grammar.getFilename(), lit.getLine(), lit.getColumn());
                    break;
                }
                ++i;
            }
        }
        this.addElementToCurrentAlt(sl);
        this.labelElement(sl, label);
        String ignore = this.ruleBlock.getIgnoreRule();
        if (!lastInRule && ignore != null) {
            this.addElementToCurrentAlt(this.createOptionalRuleRef(ignore, lit));
        }
    }

    public void refToken(Token idAssign, Token t, Token label, Token args, boolean inverted, int autoGenType, boolean lastInRule) {
        if (this.grammar instanceof LexerGrammar) {
            if (autoGenType == 2) {
                this.tool.error("AST specification ^ not allowed in lexer", this.grammar.getFilename(), t.getLine(), t.getColumn());
            }
            if (inverted) {
                this.tool.error("~TOKEN is not allowed in lexer", this.grammar.getFilename(), t.getLine(), t.getColumn());
            }
            this.refRule(idAssign, t, label, args, autoGenType);
            String ignore = this.ruleBlock.getIgnoreRule();
            if (!lastInRule && ignore != null) {
                this.addElementToCurrentAlt(this.createOptionalRuleRef(ignore, t));
            }
        } else {
            if (idAssign != null) {
                this.tool.error("Assignment from token reference only allowed in lexer", this.grammar.getFilename(), idAssign.getLine(), idAssign.getColumn());
            }
            if (args != null) {
                this.tool.error("Token reference arguments only allowed in lexer", this.grammar.getFilename(), args.getLine(), args.getColumn());
            }
            super.refToken(idAssign, t, label, args, inverted, autoGenType, lastInRule);
            TokenRefElement te = new TokenRefElement(this.grammar, t, inverted, autoGenType);
            this.addElementToCurrentAlt(te);
            this.labelElement(te, label);
        }
    }

    public void refTokenRange(Token t1, Token t2, Token label, int autoGenType, boolean lastInRule) {
        if (this.grammar instanceof LexerGrammar) {
            this.tool.error("Token range not allowed in lexer", this.grammar.getFilename(), t1.getLine(), t1.getColumn());
            return;
        }
        super.refTokenRange(t1, t2, label, autoGenType, lastInRule);
        TokenRangeElement tr = new TokenRangeElement(this.grammar, t1, t2, autoGenType);
        if (tr.end < tr.begin) {
            this.tool.error("Malformed range.", this.grammar.getFilename(), t1.getLine(), t1.getColumn());
            return;
        }
        this.addElementToCurrentAlt(tr);
        this.labelElement(tr, label);
    }

    public void refTreeSpecifier(Token treeSpec) {
        this.context().currentAlt().treeSpecifier = treeSpec;
    }

    public void refWildcard(Token t, Token label, int autoGenType) {
        super.refWildcard(t, label, autoGenType);
        WildcardElement wc = new WildcardElement(this.grammar, t, autoGenType);
        this.addElementToCurrentAlt(wc);
        this.labelElement(wc, label);
    }

    public void reset() {
        super.reset();
        this.blocks = new LList();
        this.lastRuleRef = null;
        this.ruleEnd = null;
        this.ruleBlock = null;
        this.nested = 0;
        this.currentExceptionSpec = null;
        this.grammarError = false;
    }

    public void setArgOfRuleRef(Token argAction) {
        super.setArgOfRuleRef(argAction);
        this.lastRuleRef.setArgs(argAction.getText());
    }

    public static void setBlock(AlternativeBlock b, AlternativeBlock src) {
        b.setAlternatives(src.getAlternatives());
        b.initAction = src.initAction;
        b.label = src.label;
        b.hasASynPred = src.hasASynPred;
        b.hasAnAction = src.hasAnAction;
        b.warnWhenFollowAmbig = src.warnWhenFollowAmbig;
        b.generateAmbigWarnings = src.generateAmbigWarnings;
        b.line = src.line;
        b.greedy = src.greedy;
        b.greedySet = src.greedySet;
    }

    public void setRuleOption(Token key, Token value) {
        this.ruleBlock.setOption(key, value);
    }

    public void setSubruleOption(Token key, Token value) {
        this.context().block.setOption(key, value);
    }

    public void synPred() {
        if (this.context().block.not) {
            this.tool.error("'~' cannot be applied to syntactic predicate", this.grammar.getFilename(), this.context().block.getLine(), this.context().block.getColumn());
        }
        SynPredBlock b = new SynPredBlock(this.grammar);
        MakeGrammar.setBlock(b, this.context().block);
        BlockContext old = (BlockContext)this.blocks.pop();
        this.blocks.push(new BlockContext());
        this.context().block = b;
        this.context().blockEnd = old.blockEnd;
        this.context().blockEnd.block = b;
    }

    public void zeroOrMoreSubRule() {
        if (this.context().block.not) {
            this.tool.error("'~' cannot be applied to (...)+ subrule", this.grammar.getFilename(), this.context().block.getLine(), this.context().block.getColumn());
        }
        ZeroOrMoreBlock b = new ZeroOrMoreBlock(this.grammar);
        MakeGrammar.setBlock(b, this.context().block);
        BlockContext old = (BlockContext)this.blocks.pop();
        this.blocks.push(new BlockContext());
        this.context().block = b;
        this.context().blockEnd = old.blockEnd;
        this.context().blockEnd.block = b;
    }
}

