/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.antlr;

import de.hunsicker.antlr.ANTLRLexer;
import de.hunsicker.antlr.ANTLRParser;
import de.hunsicker.antlr.CodeGenerator;
import de.hunsicker.antlr.DefaultToolErrorHandler;
import de.hunsicker.antlr.FileCopyException;
import de.hunsicker.antlr.FileLineFormatter;
import de.hunsicker.antlr.LLkAnalyzer;
import de.hunsicker.antlr.MakeGrammar;
import de.hunsicker.antlr.NameSpace;
import de.hunsicker.antlr.PreservingFileWriter;
import de.hunsicker.antlr.RecognitionException;
import de.hunsicker.antlr.StringUtils;
import de.hunsicker.antlr.TokenBuffer;
import de.hunsicker.antlr.TokenStreamException;
import de.hunsicker.antlr.ToolErrorHandler;
import de.hunsicker.antlr.collections.impl.BitSet;
import de.hunsicker.antlr.collections.impl.Vector;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

public class Tool {
    public static String version = "";
    ToolErrorHandler errorHandler;
    protected boolean hasError = false;
    boolean genDiagnostics = false;
    boolean genDocBook = false;
    boolean genHTML = false;
    protected static String outputDir = ".";
    protected String grammarFile;
    transient Reader f = new InputStreamReader(System.in);
    protected static String literalsPrefix = "LITERAL_";
    protected static boolean upperCaseMangledLiterals = false;
    protected NameSpace nameSpace = null;
    protected String namespaceAntlr = null;
    protected String namespaceStd = null;
    protected boolean genHashLines = true;
    private BitSet cmdLineArgValid = new BitSet();

    public Tool() {
        this.errorHandler = new DefaultToolErrorHandler();
    }

    public String getGrammarFile() {
        return this.grammarFile;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public NameSpace getNameSpace() {
        return this.nameSpace;
    }

    public String getNamespaceStd() {
        return this.namespaceStd;
    }

    public String getNamespaceAntlr() {
        return this.namespaceAntlr;
    }

    public boolean getGenHashLines() {
        return this.genHashLines;
    }

    public String getLiteralsPrefix() {
        return literalsPrefix;
    }

    public boolean getUpperCaseMangledLiterals() {
        return upperCaseMangledLiterals;
    }

    public void setFileLineFormatter(FileLineFormatter formatter) {
        FileLineFormatter.setFormatter(formatter);
    }

    protected void checkForInvalidArguments(String[] args, BitSet cmdLineArgValid) {
        int a = 0;
        while (a < args.length) {
            if (!cmdLineArgValid.member(a)) {
                this.warning("invalid command-line argument: " + args[a] + "; ignored");
            }
            ++a;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void copyFile(String source_name, String dest_name) throws IOException {
        IOException e22;
        Writer destination;
        block17: {
            File source_file = new File(source_name);
            File destination_file = new File(dest_name);
            Reader source = null;
            destination = null;
            try {
                int bytes_read;
                if (!source_file.exists() || !source_file.isFile()) {
                    throw new FileCopyException("FileCopy: no such source file: " + source_name);
                }
                if (!source_file.canRead()) {
                    throw new FileCopyException("FileCopy: source file is unreadable: " + source_name);
                }
                if (destination_file.exists()) {
                    if (!destination_file.isFile()) throw new FileCopyException("FileCopy: destination is not a file: " + dest_name);
                    DataInputStream in = new DataInputStream(System.in);
                    if (!destination_file.canWrite()) {
                        throw new FileCopyException("FileCopy: destination file is unwriteable: " + dest_name);
                    }
                } else {
                    File parentdir = this.parent(destination_file);
                    if (!parentdir.exists()) {
                        throw new FileCopyException("FileCopy: destination directory doesn't exist: " + dest_name);
                    }
                    if (!parentdir.canWrite()) {
                        throw new FileCopyException("FileCopy: destination directory is unwriteable: " + dest_name);
                    }
                }
                source = new BufferedReader(new FileReader(source_file));
                destination = new BufferedWriter(new FileWriter(destination_file));
                char[] buffer = new char[1024];
                while ((bytes_read = source.read(buffer, 0, 1024)) != -1) {
                    destination.write(buffer, 0, bytes_read);
                }
                Object var12_10 = null;
                if (source == null) break block17;
            }
            catch (Throwable throwable) {
                IOException e22;
                Object var12_11 = null;
                if (source != null) {
                    try {
                        source.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (destination == null) throw throwable;
                try {
                    destination.close();
                    throw throwable;
                }
                catch (IOException e22) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                source.close();
            }
            catch (IOException e22) {
                // empty catch block
            }
        }
        if (destination == null) return;
        try {
            destination.close();
            return;
        }
        catch (IOException e22) {}
    }

    public void doEverythingWrapper(String[] args) {
        int exitCode = this.doEverything(args);
        System.exit(exitCode);
    }

    public int doEverything(String[] args) {
        de.hunsicker.antlr.preprocessor.Tool preTool = new de.hunsicker.antlr.preprocessor.Tool(this, args);
        boolean preprocess_ok = preTool.preprocess();
        String[] modifiedArgs = preTool.preprocessedArgList();
        this.processArguments(modifiedArgs);
        if (!preprocess_ok) {
            return 1;
        }
        this.f = this.getGrammarReader();
        ANTLRLexer lexer = new ANTLRLexer(this.f);
        TokenBuffer tokenBuf = new TokenBuffer(lexer);
        LLkAnalyzer analyzer = new LLkAnalyzer(this);
        MakeGrammar behavior = new MakeGrammar(this, args, analyzer);
        try {
            ANTLRParser p = new ANTLRParser(tokenBuf, behavior, this);
            p.setFilename(this.grammarFile);
            p.grammar();
            if (this.hasError()) {
                System.err.println("Exiting due to errors.");
                return 1;
            }
            this.checkForInvalidArguments(modifiedArgs, this.cmdLineArgValid);
            String codeGenClassName = "de.hunsicker.antlr." + this.getLanguage(behavior) + "CodeGenerator";
            try {
                Class<?> codeGenClass = Class.forName(codeGenClassName);
                CodeGenerator codeGen = (CodeGenerator)codeGenClass.newInstance();
                codeGen.setBehavior(behavior);
                codeGen.setAnalyzer(analyzer);
                codeGen.setTool(this);
                codeGen.gen();
            }
            catch (ClassNotFoundException cnfe) {
                this.panic("Cannot instantiate code-generator: " + codeGenClassName);
            }
            catch (InstantiationException ie) {
                this.panic("Cannot instantiate code-generator: " + codeGenClassName);
            }
            catch (IllegalArgumentException ie) {
                this.panic("Cannot instantiate code-generator: " + codeGenClassName);
            }
            catch (IllegalAccessException iae) {
                this.panic("code-generator class '" + codeGenClassName + "' is not accessible");
            }
        }
        catch (RecognitionException pe) {
            System.err.println("Unhandled parser error: " + pe.getMessage());
            return 1;
        }
        catch (TokenStreamException io) {
            System.err.println("TokenStreamException: " + io.getMessage());
            return 1;
        }
        return 0;
    }

    public void error(String s) {
        this.hasError = true;
        System.err.println("error: " + s);
    }

    public void error(String s, String file, int line, int column) {
        this.hasError = true;
        System.err.println(FileLineFormatter.getFormatter().getFormatString(file, line, column) + s);
    }

    public Object factory(String p) {
        Object o = null;
        try {
            Class<?> c = Class.forName(p);
            o = c.newInstance();
        }
        catch (Exception e) {
            this.warning("Can't create an object of type " + p);
            return null;
        }
        return o;
    }

    public String fileMinusPath(String f) {
        String separator = System.getProperty("file.separator");
        int endOfPath = f.lastIndexOf(separator);
        if (endOfPath == -1) {
            return f;
        }
        return f.substring(endOfPath + 1);
    }

    public String getLanguage(MakeGrammar behavior) {
        if (this.genDiagnostics) {
            return "Diagnostic";
        }
        if (this.genHTML) {
            return "HTML";
        }
        if (this.genDocBook) {
            return "DocBook";
        }
        return behavior.language;
    }

    public String getOutputDirectory() {
        return outputDir;
    }

    private static void help() {
        System.err.println("usage: java de.hunsicker.antlr.Tool [args] file.g");
        System.err.println("  -o outputDir       specify output directory where all output generated.");
        System.err.println("  -glib superGrammar specify location of supergrammar file.");
        System.err.println("  -debug             launch the ParseView debugger upon parser invocation.");
        System.err.println("  -html              generate a html file from your grammar.");
        System.err.println("  -docbook           generate a docbook sgml file from your grammar.");
        System.err.println("  -diagnostic        generate a textfile with diagnostics.");
        System.err.println("  -trace             have all rules call traceIn/traceOut.");
        System.err.println("  -traceLexer        have lexer rules call traceIn/traceOut.");
        System.err.println("  -traceParser       have parser rules call traceIn/traceOut.");
        System.err.println("  -traceTreeParser   have tree parser rules call traceIn/traceOut.");
        System.err.println("  -h|-help|--help    this message");
    }

    public static void main(String[] args) {
        System.err.println("ANTLR Parser Generator   Version 2.7.2a2 (20020112-1)   1989-2002 jGuru.com");
        version = "2.7.2a2 (20020112-1)";
        try {
            if (args.length == 0) {
                Tool.help();
            }
            Tool theTool = new Tool();
            theTool.doEverything(args);
            theTool = null;
        }
        catch (Exception e) {
            System.err.println(System.getProperty("line.separator") + System.getProperty("line.separator"));
            System.err.println("#$%%*&@# internal error: " + e.toString());
            System.err.println("[complain to nearest government official");
            System.err.println(" or send hate-mail to parrt@jguru.com;");
            System.err.println(" please send stack trace with report.]" + System.getProperty("line.separator"));
            e.printStackTrace();
        }
        System.exit(0);
    }

    public PrintWriter openOutputFile(String f) throws IOException {
        return new PrintWriter(new PreservingFileWriter(outputDir + System.getProperty("file.separator") + f));
    }

    public Reader getGrammarReader() {
        try {
            if (this.grammarFile != null) {
                this.f = new BufferedReader(new FileReader(this.grammarFile));
            }
        }
        catch (IOException e) {
            this.panic("Error: cannot open grammar file " + this.grammarFile);
            Tool.help();
            System.exit(1);
        }
        return this.f;
    }

    public void panic() {
        System.err.println("panic");
        System.exit(1);
    }

    public void panic(String s) {
        System.err.println("panic: " + s);
        System.exit(1);
    }

    public File parent(File f) {
        String dirname = f.getParent();
        if (dirname == null) {
            if (f.isAbsolute()) {
                return new File(File.separator);
            }
            return new File(System.getProperty("user.dir"));
        }
        return new File(dirname);
    }

    /*
     * Unable to fully structure code
     */
    public static Vector parseSeparatedList(String list, char separator) {
        v = new Vector(10);
        buf = new StringBuffer(100);
        i = 0;
        ** GOTO lbl14
        {
            buf.append(list.charAt(i));
            ++i;
            do {
                if (i < list.length() && list.charAt(i) != separator) continue block0;
                v.appendElement(buf.toString());
                buf.setLength(0);
                if (i >= list.length()) continue;
                ++i;
lbl14:
                // 3 sources

            } while (i < list.length());
        }
        if (v.size() == 0) {
            return null;
        }
        return v;
    }

    public String pathToFile(String f) {
        String separator = System.getProperty("file.separator");
        int endOfPath = f.lastIndexOf(separator);
        if (endOfPath == -1) {
            return "." + System.getProperty("file.separator");
        }
        return f.substring(0, endOfPath + 1);
    }

    protected void processArguments(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-diagnostic")) {
                this.genDiagnostics = true;
                this.genHTML = false;
                this.setArgOK(i);
            } else if (args[i].equals("-o")) {
                this.setArgOK(i);
                if (i + 1 >= args.length) {
                    this.error("missing output directory with -o option; ignoring");
                } else {
                    this.setOutputDirectory(args[++i]);
                    this.setArgOK(i);
                }
            } else if (args[i].equals("-html")) {
                this.genHTML = true;
                this.genDiagnostics = false;
                this.setArgOK(i);
            } else if (args[i].equals("-docbook")) {
                this.genDocBook = true;
                this.genDiagnostics = false;
                this.setArgOK(i);
            } else if (args[i].equals("-h") || args[i].equals("-help") || args[i].equals("--help")) {
                Tool.help();
                System.exit(0);
            } else if (args[i].charAt(0) != '-') {
                this.grammarFile = args[i];
                this.setArgOK(i);
            }
            ++i;
        }
    }

    public void setArgOK(int i) {
        this.cmdLineArgValid.add(i);
    }

    public void setOutputDirectory(String o) {
        outputDir = o;
    }

    public void toolError(String s) {
        System.err.println("error: " + s);
    }

    public void warning(String s) {
        System.err.println("warning: " + s);
    }

    public void warning(String s, String file, int line, int column) {
        System.err.println(FileLineFormatter.getFormatter().getFormatString(file, line, column) + "warning:" + s);
    }

    public void warning(String[] s, String file, int line, int column) {
        if (s == null || s.length == 0) {
            this.panic("bad multi-line message to Tool.warning");
        }
        System.err.println(FileLineFormatter.getFormatter().getFormatString(file, line, column) + "warning:" + s[0]);
        int i = 1;
        while (i < s.length) {
            System.err.println(FileLineFormatter.getFormatter().getFormatString(file, line, column) + s[i]);
            ++i;
        }
    }

    public void setNameSpace(String name) {
        if (null == this.nameSpace) {
            this.nameSpace = new NameSpace(StringUtils.stripFrontBack(name, "\"", "\""));
        }
    }
}

