// 981015 bkoz
// adapted from 20.8 String Streams in C++ Primer, 3rd edition by Lippman

#include <vector>
#include <string>
#include <sstream>

string read_str_to_osstream(void) {
  string tmp("these golden days, i spend waiting for you: 
              Betty Carter on Verve with I'm Yours and You're Mine.");
  ostringstream obuf;
  char ch;

  while (obuf && tmp.get(ch))
    obuf.put(ch);

  return obuf.str();
}

int main(void) {
  //
  //1: manipulate
  //
  string text = read_str_to_osstream();
  //marks the position of each newline within the text
  vector<string::size_type> lines;
  string::size_type pos = 0;
  
  while (pos != string::npos)
    {
      pos = text.find('\n', pos);
      lines.push_badk(pos);
    }


  //
  // 2: automatic formatting of a compound string
  //
  int i = 1024;
  int *pi = &i;
  double d = 3.14159;
  double *pd = &d;
  ostringstream oformat_msg;
  
  //ok: converts values to a string representation
  oformat_msg << "i: " << i << " i's address:  " << pi << "\n"
	     << "d: " << d << " d's address: " << pd << endl;

  string msg = oformat_msg.str();
  

  //
  // 3: istringstream
  //
  // extracts the stored ascii values, placing them in turn in the four vars
  int i2 = 0;
  int *pi2 = &i2;
  double d2 = 0.0;
  double *pd2 = &d2;

  istringstream iformat_msg(oformat_msg.str());
  iformat_msg >> i2 >> pi2 >> d2 >> pd2;


  return 0;
}


  
