/*
 * Author: Heinz Mauelshagen, Germany
 *
 * May 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */


#include <liblvm.h>

char *lv_get_name ( vg_t *vg, int lv_number) {
   int l = 0;
   char *ret = NULL;

#ifdef DEBUG
   debug ( "lv_get_name -- CALLED\n");
#endif

   if ( vg == NULL || vg_check_name ( vg->vg_name) < 0) return NULL;

   for ( l = 0; l < vg->lv_max; l++) {
      if ( vg->lv[l] != NULL && vg->lv[l]->lv_number == lv_number) {
         ret = vg->lv[l]->lv_name;
         break;
      }
   }

#ifdef DEBUG
   debug ( "lv_get_name -- LEAVING with %s\n", ret);
#endif
   return ret;
}
