/*
 * Author: Heinz Mauelshagen, Germany
 *
 * May 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#include <liblvm.h>


int lvm_check_dev ( struct stat *stat_b, int check_mode) {
   int ret = 0;

   if ( stat_b == NULL) return -LVM_EPARA;

   if ( ( MAJOR ( stat_b->st_rdev) == SCSI_DISK_MAJOR ||
          MAJOR ( stat_b->st_rdev) == IDE0_MAJOR ||
          MAJOR ( stat_b->st_rdev) == IDE1_MAJOR ||
          MAJOR ( stat_b->st_rdev) == IDE2_MAJOR ||
          MAJOR ( stat_b->st_rdev) == IDE3_MAJOR ||
#if ( OS_Major > 1) && ( OS_Minor > 0) && ( OS_SubMinor > 97)
          MAJOR ( stat_b->st_rdev) == IDE4_MAJOR ||
          MAJOR ( stat_b->st_rdev) == IDE5_MAJOR ||
#endif
          MAJOR ( stat_b->st_rdev) == MD_MAJOR)) ret = TRUE;

   if ( ret == TRUE && check_mode == TRUE && ! S_ISBLK ( stat_b->st_mode))
      ret = FALSE;

   return ret;
}
