/*
 * Author: Heinz Mauelshagen, Germany
 *
 * March-May 1997
 * January 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 * 01/17/1998 - ported to Linux 2.1.79
 *
 */

#include <liblvm.h>
#ifdef __KERNEL__
#   undef __KERNEL__
#   define __HM_KERNEL__
#endif
#include <signal.h>
#ifdef __HM_KERNEL__
#   undef __HM_KERNEL__
#   define __KERNEL__
#endif


void lvm_interrupt ( void) {
#ifndef	LVM_DONT_INTERRUPT
   int s;

   for ( s = 0; s < NSIG; s++) signal ( s, SIG_DFL);
#endif
   return;
}

void lvm_dont_interrupt ( int sig) {
#ifndef	LVM_DONT_INTERRUPT
   int s;

   for ( s = 0; s < NSIG; s++)
      if ( s != SIGKILL)
         signal ( s, SIG_IGN);
#endif
   return;
}
