/*
 * Author: Heinz Mauelshagen, Germany
 *
 * March,October 1997
 * May 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    10/07/1997 - added extended partiton sizing
 *    11/07/1997 - corrected deadlock looping through partition tables
 *    05/04/1998 - added support for non partitioned disks
 *
 */

#include <liblvm.h>

int pv_get_size ( char *dev_name, struct partition *part_ptr) {
   int i = 0;
   int extended_flag = 0;
   int first = 0;
   int part_i = 0;
   int part_i_tmp = 0;
   int pv_handle = -1;
   int ret = 0;
   static char buffer[SECTOR_SIZE];
   loff_t offset = 0;
   loff_t extended_offset = 0;
   struct partition *part = ( struct partition *) ( buffer + 0x1be);
   unsigned short *s_buffer = ( unsigned short *) buffer;
   char disk_dev_name[NAME_LEN];

#ifdef DEBUG
   debug ( "pv_get_size -- CALLED with %s and %X\n",
             dev_name, ( uint) part_ptr);
#endif

   if ( dev_name == NULL ||
        pv_check_name ( dev_name) < 0) return -LVM_EPARA;

   strcpy ( disk_dev_name, dev_name);
   disk_dev_name[DISK_NAME_LEN] = 0;
   memset ( buffer, 0, SECTOR_SIZE);

   part_i = pv_check_part ( dev_name);

   first = 1;
   if ( ( pv_handle = open ( disk_dev_name, O_RDONLY)) == -1)
      ret = -LVM_EPV_GET_SIZE_OPEN;
   else while ( ret == 0) {
#ifdef DEBUG
      debug ( "pv_get_size -- BEFORE llseek %X:%X\n",
              ( uint) ( offset >> 32),
              ( uint) ( offset & 0xFFFFFFFF));
#endif
      if ( llseek ( pv_handle, offset * SECTOR_SIZE, SEEK_SET) == -1) {
         ret = -LVM_EPV_GET_SIZE_LLSEEK;
         break;
      }

      if ( read ( pv_handle, buffer, SECTOR_SIZE) != SECTOR_SIZE) {
         ret = -LVM_EPV_GET_SIZE_READ;
         break;
      }

      /* no partition table present --> use whole disk */
      if ( s_buffer[255] != 0xAA55) {
         if ( ioctl ( pv_handle, BLKGETSIZE, &ret) == -1) {
            ret = -LVM_EPV_GET_SIZE_IOCTL;
            break;
         }
         memset ( buffer, 0, SECTOR_SIZE);
         break;
      }

      /* walk thrugh primary partitions */
      extended_flag = 0;
      for ( i = 0; i < 4; i++) {
#ifdef DEBUG
         debug ( "pv_get_size -- part[%d].sys_ind: %1X  "
                 "part[%d].nr_sects: %d\n",
                 i, part[i].sys_ind, i, part[i].nr_sects);
#endif
         /* is it a welcome extended partition? */
         if ( part[i].sys_ind == DOS_EXTENDED_PARTITION ||
              part[i].sys_ind == LINUX_EXTENDED_PARTITION) {
#ifdef DEBUG
            debug ( "pv_get_size -- DOS/LINUX_EXTENDED_PARTITION\n");
#endif
            extended_flag = 1;
            offset = extended_offset + part[i].start_sect;
            if ( extended_offset == 0) extended_offset = part[i].start_sect;
            if ( first == 1) part_i_tmp++;
         } else if ( first == 1) {
#ifdef DEBUG
            debug ( "pv_get_size -- first == 1\n");
#endif
            if ( i == part_i) {
               if ( part[i].sys_ind == 0) ret = -LVM_EPV_GET_SIZE_NO_PRIMARY;
            } else part_i_tmp++;
         } else if ( part[i].sys_ind != 0) {
#ifdef DEBUG
            debug ( "pv_get_size -- first == 1\n");
#endif
            part_i_tmp++;
         }

         if ( part_i == part_i_tmp) {
#ifdef DEBUG
            debug ( "pv_get_size -- part_i == part_i_tmp\n");
#endif
            if ( part[i].nr_sects == 0) ret = -LVM_EPV_GET_SIZE_PART;
            else ret = part[i].nr_sects;
            goto pv_get_size_end;
         }
      }
      first = 0;
      if ( extended_flag == 0 && part_i_tmp != part_i)
         ret = -LVM_EPV_GET_SIZE_NO_EXTENDED;
   }

pv_get_size_end:
   if ( part_ptr != NULL && ret > 0) memcpy ( part_ptr,
                                              &part[i],
                                              sizeof ( struct partition));

   if ( pv_handle != -1) close ( pv_handle);

#ifdef DEBUG
   debug ( "pv_get_size -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
