/*
 * Author: Heinz Mauelshagen, Germany (mge@ez-darmstadt.telekom.de)
 *
 * May,October 1997
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    10/8/97 - replaced strlen by sizeof for static string
 *
 */

#include <liblvm.h>
#include <sys/utsname.h>

int system_id_set ( char *system_id) {
   struct utsname uts;

   if ( uname ( &uts) != 0) return -LVM_ESYSTEM_ID_SET_UNAME;
   sprintf ( system_id, "%s%lu%c", uts.nodename, time ( NULL), 0);

   return 0;
}


int system_id_set_exported ( char *system_id) {
   struct utsname uts;

   if ( uname ( &uts) != 0) return -LVM_ESYSTEM_ID_SET_UNAME;
   sprintf ( system_id, "%s%s%lu%c", EXPORTED, uts.nodename, time ( NULL), 0);

   return 0;
}


int system_id_set_imported ( char *system_id) {
   sprintf ( system_id, "%s%s%c", IMPORTED,
                        &system_id[sizeof ( EXPORTED) - 1], 0);

   return 0;
}


int system_id_check_exported ( char *system_id) {
   if ( strncmp ( system_id, EXPORTED, sizeof ( EXPORTED) - 1) == 0)
      return TRUE;
   else
      return FALSE;
}


int system_id_check_imported ( char *system_id) {
   if ( strncmp ( system_id, IMPORTED, sizeof ( IMPORTED) - 1) == 0)
      return TRUE;
   else
      return FALSE;
}
