/*
 * Author: Heinz Mauelshagen, Germany
 *
 * March-May 1997
 * January 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    01/11/1998 - seperated from previous vg_name.c
 *    02/12/1998 - changed for free volume group names
 *    05/12/1998 - avoided checking vg_name against LVM_PV_NEW
 *
 */

#include <liblvm.h>

int vg_check_name ( char *vg_name) {
   int ret = 0;

#ifdef DEBUG
   debug ( "vg_check_name -- CALLED\n");
#endif

   if ( vg_name == NULL) return -LVM_EPARA;

   if ( strncmp ( vg_name, "/dev/", 5) == 0) strcpy ( vg_name, &vg_name[5]);

   if ( strchr ( vg_name, '/') != NULL ||
        strlen ( vg_name) > ( NAME_LEN - 1) / 2) ret = -LVM_EVG_CHECK_NAME;

#ifdef DEBUG
   debug ( "vg_check_name -- LEAVING\n");
#endif
   return ret;
}
