/*
 * Author: Heinz Mauelshagen, Germany (mge@ez-darmstadt.telekom.de)
 *
 * November 1997
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#include <liblvm.h>

int vg_remove_dir_and_group_and_nodes ( char *vg_name) {
   char system_buffer[NAME_LEN+20];

#ifdef DEBUG
   debug ( "vg_remove_dir_and_group_and_nodes -- CALLED\n");
#endif

   if ( vg_name == NULL || vg_check_name ( vg_name) < 0) return -LVM_EPARA;

   /* remove the volume group directory */
   sprintf ( system_buffer, "rm -fr /dev/%s%c", vg_name, 0);

#ifdef DEBUG
   debug ( "vg_remove_dir_and_group_and_nodes -- LEAVING\n");
#endif

   return system ( system_buffer);
}
   
