/*
 * tools/lib/lv_check_stripesize.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * May 1997
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with GNU CC; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#include <liblvm.h>

int lv_check_stripesize ( int stripesize) {
   int exp2 = -1;
   int stripesize_this;

#ifdef DEBUG
   debug ( "lv_check_check_stripesize -- CALLED\n");
#endif

   if ( stripesize == 1) return 0;

   stripesize_this = stripesize;
   while ( ( stripesize_this >>= 1) > 0) exp2++;

   if ( stripesize >= LVM_MIN_STRIPE_SIZE &&
        stripesize <= LVM_MAX_STRIPE_SIZE &&
        ( stripesize % ( 1<<exp2)) == 0 ) return 0;

#ifdef DEBUG
   debug ( "lv_check_check_stripesize -- LEAVING\n");
#endif
   return -LVM_ELV_CHECK_STRIPE_SIZE;
}
