/*
 * tools/lib/lvm_check_chars.c
 *
 * Copyright (C) 1998  Heinz Mauelshagen, Germany
 *
 * September 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with GNU CC; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#include <liblvm.h>

int lvm_check_chars ( char *name) {
   int ret = 0;

#ifdef DEBUG
   debug ( "lvm_check_chars -- CALLED\n");
#endif

   if ( name == NULL) return -LVM_EPARAM;

   while ( *name != 0) {
      if ( !isalnum ( *name) &&
           *name != '_' &&
           *name != '-' &&
           *name != '+' &&
           *name != '/') {
         ret = -LVM_ELVM_CHECK_CHARS;
         break;
      }
      name++;
   }

#ifdef DEBUG
   debug ( "lvm_check_chars -- LEAVING\n");
#endif
   return ret;
}
