/*
 * tools/lib/lvm_check_dev.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * May,August,November 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with GNU CC; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 * 08/30/1998 - checked for direct MAJOR due to seperation of disk
 *              and core structures
 * 11/12/1998 - added new SCSI majors
 *
 */

#include <liblvm.h>


int lvm_check_dev ( struct stat *stat_b, int check_mode) {
   int ret = UNDEF;

   if ( stat_b == NULL) return -LVM_EPARAM;

#ifndef SCSI_DISK0_MAJOR
   if ( stat_b->st_rdev == SCSI_DISK_MAJOR ||
#else
   if ( stat_b->st_rdev == SCSI_DISK0_MAJOR ||
        stat_b->st_rdev == SCSI_DISK1_MAJOR ||
        stat_b->st_rdev == SCSI_DISK2_MAJOR ||
        stat_b->st_rdev == SCSI_DISK3_MAJOR ||
        stat_b->st_rdev == SCSI_DISK4_MAJOR ||
        stat_b->st_rdev == SCSI_DISK5_MAJOR ||
        stat_b->st_rdev == SCSI_DISK6_MAJOR ||
        stat_b->st_rdev == SCSI_DISK7_MAJOR ||
#endif
        stat_b->st_rdev == IDE0_MAJOR ||
        stat_b->st_rdev == IDE1_MAJOR ||
        stat_b->st_rdev == IDE2_MAJOR ||
        stat_b->st_rdev == IDE3_MAJOR ||
#if LVM_VERSION_CODE >= KERNEL_VERSION ( 2, 0, 97)
        stat_b->st_rdev == IDE4_MAJOR ||
        stat_b->st_rdev == IDE5_MAJOR ||
#endif
        stat_b->st_rdev == MD_MAJOR   ||
#ifndef SCSI_DISK0_MAJOR
        MAJOR ( stat_b->st_rdev) == SCSI_DISK_MAJOR ||
#else
        MAJOR ( stat_b->st_rdev) == SCSI_DISK0_MAJOR ||
        MAJOR ( stat_b->st_rdev) == SCSI_DISK1_MAJOR ||
        MAJOR ( stat_b->st_rdev) == SCSI_DISK2_MAJOR ||
        MAJOR ( stat_b->st_rdev) == SCSI_DISK3_MAJOR ||
        MAJOR ( stat_b->st_rdev) == SCSI_DISK4_MAJOR ||
        MAJOR ( stat_b->st_rdev) == SCSI_DISK5_MAJOR ||
        MAJOR ( stat_b->st_rdev) == SCSI_DISK6_MAJOR ||
        MAJOR ( stat_b->st_rdev) == SCSI_DISK7_MAJOR ||
#endif
        MAJOR ( stat_b->st_rdev) == IDE0_MAJOR ||
        MAJOR ( stat_b->st_rdev) == IDE1_MAJOR ||
        MAJOR ( stat_b->st_rdev) == IDE2_MAJOR ||
        MAJOR ( stat_b->st_rdev) == IDE3_MAJOR ||
#if LVM_VERSION_CODE >= KERNEL_VERSION ( 2, 0, 97)
        MAJOR ( stat_b->st_rdev) == IDE4_MAJOR ||
        MAJOR ( stat_b->st_rdev) == IDE5_MAJOR ||
#endif
        MAJOR ( stat_b->st_rdev) == MD_MAJOR) ret = TRUE;

   if ( ret == TRUE && check_mode == TRUE && ! S_ISBLK ( stat_b->st_mode))
      ret = FALSE;

   return ret;
}
