/*
 * tools/lib/lvm_lock.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * June 1997
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with GNU CC; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    06/29/1998 - added creation of missing device special in lvm_lock()
 *    08/02/1998 - used official char major
 *
 */

#include <liblvm.h>

static int lock = -1;

int lvm_lock ( void) {
   int i = 0;

   if ( lock != -1) return -LVM_ELVM_LOCK_YET_LOCKED;

   for ( i = 0; i < 2; i++) {
      if ( ( lock = open ( LVM_DEV, O_RDONLY)) == -1) {
         if ( errno == ENOENT)
            mknod ( LVM_DEV,
                    S_IFCHR | S_IRUSR | S_IWUSR | S_IRGRP,
                    LVM_CHAR_MAJOR << MINORBITS);
            chmod ( LVM_DEV, 0640);
      } else break;
   }

   if ( lock == -1) return -errno;
   else             return 0;
}


int lvm_unlock ( void) {
   if ( lock == -1) return -LVM_ELVM_UNLOCK;
   close ( lock);
   lock = -1;

   return 0;
}
