/*
 * tools/lib/pv_check_new.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * March 1997
 * May 1998
 * January 1999
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with GNU CC; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    05/12/1998 - avoided checking vg_name against LVM_PV_NEW
 *    01/13/1999 - enhanced checks
 *
 */

#include <liblvm.h>

int pv_check_new ( pv_t *pv) {
   int i = 0;
   int ret = FALSE;

#ifdef DEBUG
   debug ( "pv_check_new -- CALLED\n");
#endif

   if ( pv == NULL) ret = -LVM_EPARAM;
   else {
      for ( i = 0; i < sizeof ( pv->vg_name); i++)
         if ( pv->vg_name[i] != 0) 
            break;

      if ( i == sizeof ( pv->vg_name) &&
           pv->pe_total == 0) ret = TRUE;
   }

#ifdef DEBUG
   debug ( "pv_check_new -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
