/*
 * tools/lib/vg_create_dir_and_group_and_nodes.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * September 1997
 * January 1998
 * January 1999
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with GNU CC; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    01/17/1998 - fixed lv index bug
 *    01/26/1999 - made volume group directory prefix a preprocessor option
 *
 */

#include <liblvm.h>

int vg_create_dir_and_group_and_nodes ( vg_t *vg, int opt_v) {
   int l;
   int ret;
   int total_ret = 0;

#ifdef DEBUG
   debug ( "vg_create_dir_and_group_and_nodes -- CALLED\n");
#endif

   if ( vg == NULL || vg_check_consistency_with_pv_and_lv < 0 ||
        opt_v < 0) return -LVM_EPARAM;

   /* make volume group directory and group special file */
   if ( opt_v > 0) printf ( "%s -- creating and group character "
                            "special file for %s\n",
                            cmd, vg->vg_name);
   if ( ( ret = vg_create_dir_and_group ( vg)) < 0) {
      total_ret--;
      if ( ret == -LVM_EVG_CREATE_DIR_AND_GROUP_MKDIR) {
         fprintf ( stderr, "%s -- problem creating volume group "
                           "directory "
                           LVM_DIR_PREFIX
                           "%s\n",
                           cmd, vg->vg_name);
      } else if ( ret == -LVM_EVG_CREATE_DIR_AND_GROUP_CHMOD_DIR) {
         fprintf ( stderr, "%s -- problem changing permission "
                           "for volume group directory "
                           LVM_DIR_PREFIX
                           "%s\n",
                           cmd, vg->vg_name);
      } else if ( ret == -LVM_EVG_CREATE_DIR_AND_GROUP_CHMOD_GROUP) {
         fprintf ( stderr, "%s -- problem changing permission "
                           "for volume group file "
                           LVM_DIR_PREFIX
                           "%s/group\n",
                           cmd, vg->vg_name);
      } else {
         fprintf ( stderr, "%s -- ERROR %d creating volume group directory "
                           LVM_DIR_PREFIX
                           "%s\n",
                           cmd, ret, vg->vg_name);
      }
   }

   /* create logical volume special files */
   if ( opt_v > 0) printf ( "%s -- creating block device special "
                            "files for %s\n",
                            cmd, vg->vg_name);
   for ( l = 0; l < vg->lv_max; l++) {
      if ( vg->lv[l] != NULL) {
         if ( ( ret = lv_create_node ( vg->lv[l]->lv_name,
                                       vg->vg_number,
                                       vg->lv[l]->lv_number + 1)) < 0) {
            total_ret--;
            if ( ret  == -LVM_ELV_CREATE_MODE_MKNOD) {
               fprintf ( stderr, "%s -- problem creating special file %s\n",
                         cmd, vg->lv[l]->lv_name);
            } else if ( ret == -LVM_ELV_CREATE_MODE_CHMOD) {
               fprintf ( stderr, "%s -- problem setting permissions of "
                                 "special file %s\n",
                         cmd, vg->lv[l]->lv_name);
            } else {
               fprintf ( stderr, "%s -- ERROR %d with special file %s\n",
                         cmd, ret, vg->lv[l]->lv_name);
            }
         }
      }
   }

#ifdef DEBUG
   debug ( "vg_create_dir_and_group_and_nodes -- LEAVING\n");
#endif

   return ( total_ret);
}
