/*
 * tools/lib/vg_read_from_pv.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * March,October,November 1997
 * June,August 1998
 * January 1999
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 * Changelog
 *
 *    13/11/1997 - implemented vg_read_from_pv ()
 *
 */

#include <liblvm.h>


int vg_read_from_pv ( char *pv_name, vg_t **vg) {
   int pv_handle = -1;
   int ret = 0;
   static vg_disk_t vg_this;
   pv_t *pv = NULL;

#ifdef DEBUG
   debug ( "vg_read_from_pv -- CALLED\n");
#endif

   if ( pv_name == NULL ||
        pv_check_name ( pv_name) < 0 ||
        vg == NULL) return -LVM_EPARAM;

   if ( pv_read ( pv_name, &pv, NULL) < 0)
      ret = -LVM_EVG_READ_FROM_PV_PV_READ;
   else if ( pv_check_consistency ( pv) < 0)
      ret = -LVM_EVG_READ_FROM_PV_CHECK_CONSISTENCY;
   else if ( ( pv_handle = open ( pv_name, O_RDONLY)) == -1)
      ret = -LVM_EVG_READ_FROM_PV_OPEN;
   else if ( lseek ( pv_handle, pv->vg_on_disk.base, SEEK_SET) != 
             pv->vg_on_disk.base) ret = -LVM_EVG_READ_FROM_PV_LSEEK;
   else if ( read ( pv_handle, &vg_this, sizeof ( vg_this)) != \
             sizeof ( vg_this)) ret = -LVM_EVG_READ_FROM_PV_READ;
   else {
      *vg = vg_copy_from_disk ( &vg_this);
      (*vg)->pv[0] = pv;
      if ( (*vg)->vg_status & VG_EXPORTED) ret = -LVM_EVG_READ_VG_EXPORTED;
      if ( ret == 0 && pv->version != LVM_STRUCT_VERSION)
         ret = -LVM_EVG_READ_FROM_PV_LVM_STRUCT_VERSION;
   }

   if ( pv_handle != -1) close ( pv_handle);
   if ( ret != 0) *vg = NULL;

#ifdef DEBUG
   debug ( "vg_read_from_pv -- LEAVING %d\n", ret);
#endif
   return ret;
}
