/*
 * tools/lib/lvm_check_partitioned_dev.c
 *
 * Copyright (C) 1999  Heinz Mauelshagen, Germany
 *
 * March,July 1999
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 * Changelog
 *
 *    05/07/1999 - added 2.3.x new IDE majors
 *
 */

#include <liblvm.h>


int lvm_check_partitioned_dev ( dev_t st_rdev) {
   int ret = FALSE;
   int i = 0;
   dev_t valid_majors[] = {
#ifndef SCSI_DISK0_MAJOR
      SCSI_DISK_MAJOR,
#else
      SCSI_DISK0_MAJOR,
      SCSI_DISK1_MAJOR,
      SCSI_DISK2_MAJOR,
      SCSI_DISK3_MAJOR,
      SCSI_DISK4_MAJOR,
      SCSI_DISK5_MAJOR,
      SCSI_DISK6_MAJOR,
      SCSI_DISK7_MAJOR,
#endif
      IDE0_MAJOR,
      IDE1_MAJOR,
      IDE2_MAJOR,
      IDE3_MAJOR,
#ifdef IDE4_MAJOR
      IDE4_MAJOR,
      IDE5_MAJOR,
#endif
#ifdef IDE6_MAJOR
      IDE6_MAJOR,
#endif
#ifdef IDE7_MAJOR
      IDE7_MAJOR,
#endif
      -1
   };


   if ( st_rdev == 0) return -LVM_EPARAM;

   for ( i = 0; valid_majors[i] != -1; i++) {
      if ( MAJOR ( st_rdev) == valid_majors[i]) {
         ret = TRUE;
         break;
      }
   }

   return ret;
}
