/*
 * tools/lib/vg_check_pe_size.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * May 1997
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

#include <liblvm.h>

int vg_check_pe_size ( ulong pe_size) {
   int exp2 = -1;
   ulong pe_size_this;

#ifdef DEBUG
   debug ( "vg_check_check_pe_size -- CALLED\n");
#endif

   pe_size_this = pe_size;
   while ( ( pe_size_this >>= 1) > 0) exp2++;

   if ( pe_size >= LVM_MIN_PE_SIZE &&
        pe_size <= LVM_MAX_PE_SIZE &&
        ( pe_size % ( 1<<exp2)) == 0 ) return 0;

#ifdef DEBUG
   debug ( "vg_check_check_pe_size -- LEAVING\n");
#endif
   return -LVM_EVG_CHECK_PE_SIZE;
}
