/*
 * tools/lib/lvm_check_dev.c
 *
 * Copyright (C) 1998 - 1999  Heinz Mauelshagen, Germany
 *
 * May,August,November 1998
 * February,April 1999
 * January 2000
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 * Changelog
 *
 *    30/08/1998 - checked for direct MAJOR due to seperation of disk
 *                 and core structures
 *    12/11/1998 - added new SCSI majors
 *    21/02/1999 - changed to check in loop
 *    17/03/1999 - added loop device support
 *    22/04/1999 - DAC960 support by Matthew Taylor <M.Taylor@rbgkew.org.uk>
 *    31/01/2000 - use debug_enter()/debug_leave()
 *
 */

#include <liblvm.h>


int lvm_check_dev ( struct stat *stat_b, int check_mode) {
   int ret = FALSE;
   int i = 0;
   short major = 0;
   dev_t valid_majors[] = {
#ifndef SCSI_DISK0_MAJOR
      SCSI_DISK_MAJOR,
#else
      SCSI_DISK0_MAJOR,
      SCSI_DISK1_MAJOR,
      SCSI_DISK2_MAJOR,
      SCSI_DISK3_MAJOR,
      SCSI_DISK4_MAJOR,
      SCSI_DISK5_MAJOR,
      SCSI_DISK6_MAJOR,
      SCSI_DISK7_MAJOR,
#endif
      IDE0_MAJOR,
      IDE1_MAJOR,
      IDE2_MAJOR,
      IDE3_MAJOR,
#ifdef IDE4_MAJOR
      IDE4_MAJOR,
      IDE5_MAJOR,
#endif
#ifdef	DAC960_MAJOR
      DAC960_MAJOR,
      DAC960_MAJOR+1,
      DAC960_MAJOR+2,
      DAC960_MAJOR+3,
      DAC960_MAJOR+4,
      DAC960_MAJOR+5,
      DAC960_MAJOR+6,
      DAC960_MAJOR+7,
#endif
#ifdef LOOP_MAJOR
      LOOP_MAJOR,
#endif
#ifdef MD_MAJOR
      MD_MAJOR,
#endif
#ifdef NBD_MAJOR
      NBD_MAJOR,
#endif
#ifdef	COMPAQ_SMART2_MAJOR
      COMPAQ_SMART2_MAJOR,
#endif
#ifdef	COMPAQ_SMART2_MAJOR1
      COMPAQ_SMART2_MAJOR1,
#endif
#ifdef	COMPAQ_SMART2_MAJOR2
      COMPAQ_SMART2_MAJOR2,
#endif
#ifdef	COMPAQ_SMART2_MAJOR3
      COMPAQ_SMART2_MAJOR3,
#endif
#ifdef	COMPAQ_SMART2_MAJOR4
      COMPAQ_SMART2_MAJOR4,
#endif
#ifdef	COMPAQ_SMART2_MAJOR5
      COMPAQ_SMART2_MAJOR5,
#endif
#ifdef	COMPAQ_SMART2_MAJOR6
      COMPAQ_SMART2_MAJOR6,
#endif
#ifdef	COMPAQ_SMART2_MAJOR7
      COMPAQ_SMART2_MAJOR7,
#endif
      -1
   };



#ifdef DEBUG
   debug_enter ( "lvm_check_dev -- CALLED\n");
#endif

   if ( stat_b == NULL ||
        ( check_mode != TRUE && check_mode != FALSE) ) ret = -LVM_EPARAM;
   else {
      major = MAJOR ( stat_b->st_rdev);
      for ( i = 0; valid_majors[i] != -1; i++) {
         if (  stat_b->st_rdev == valid_majors[i] ||
               major           == valid_majors[i]) {
            ret = TRUE;
            break;
         }
      }
   }

   if ( ret == TRUE && check_mode == TRUE && ! S_ISBLK ( stat_b->st_mode))
      ret = FALSE;

#ifdef DEBUG
   debug_leave ( "lvm_check_dev -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
