/*
 * tools/lib/lvm_error.c
 *
 * Copyright (C)  2000  Heinz Mauelshagen, Germany
 *
 * February 2000
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#include <liblvm.h>


char *lvm_error ( int error) {
   int c = 0;
   char *ret = NULL;
   static char buffer[16];
   struct lvm_error_struct {
      ushort error;
      char *errstr;
   } lvm_errors[] = {
      { LVM_EPARAM, "parameter error"},
      { LVM_ELVM_CHECK_CHARS, "lvm_check_chars(): invalid character"},
      { LVM_ELVM_FIND_VG_REALLOC, "pv_find_all_pv_names(): realloc"},
      { LVM_ELVM_IOP_VERSION_OPEN, "i/o protocoll version"},
      { LVM_ELVM_LOCK_YET_LOCKED, "lvm_lock(): already locked"},
      { LVM_ELVM_TAB_CREATE_LVMTAB, "creating lvmtab"},
      { LVM_ELVM_TAB_CREATE_LVMTAB_DIR, "creating lvmtab directory"},
      { LVM_ELVM_TAB_GET_FREE_BLK_DEV_LVM_TAB_VG_CHECK_EXIST,
        "checking existence of volume group"},
      { LVM_ELVM_TAB_GET_FREE_BLK_DEV_NO_DEV, "no block device special"},
      { LVM_ELVM_TAB_GET_FREE_BLK_DEV_REALLOC,
        "lvm_tab_get_free_blk_dev(): realloc block device"},
      { LVM_ELVM_TAB_GET_FREE_VG_NUMBER_MALLOC,
        "lvm_tab_get_free_vg_number(): malloc"},
      { LVM_ELVM_TAB_LV_READ_BY_NAME_LVM_TAB_VG_READ_WITH_PV_AND_LV,
        "reading VG with PVs and LVs"},
      { LVM_ELVM_TAB_LV_READ_BY_NAME_LV_GET_INDEX_BY_NAME,
        "LV get index by name"},
      { LVM_ELVM_TAB_READ_FSTAT, "getting file status"},
      { LVM_ELVM_TAB_READ_MALLOC, "lvm_tab_read(): malloc"},
      { LVM_ELVM_TAB_READ_OPEN, "lvm_tab_read(): open"},
      { LVM_ELVM_TAB_READ_PV_CHECK_NAME, "lvm_tab_read(): pv_check_name"},
      { LVM_ELVM_TAB_READ_READ, "lvm_tab_read(): read"},
      { LVM_ELVM_TAB_READ_SIZE, "lvm_tab_read(): size"},
      { LVM_ELVM_TAB_READ_VG_CHECK_NAME, "lvm_tab_read(): vg_check_name"},
      { LVM_ELVM_TAB_VG_CHECK_EXIST_ALL_VG_REALLOC,
        "lvm_tab_vg_check_exist_all_vg(): realloc"},
      { LVM_ELVM_TAB_VG_INSERT_REALLOC, "lvm_tab_vg_insert(): realloc"},
      { LVM_ELVM_TAB_VG_INSERT_VG_EXISTS, "lvm_tab_vg_insert: VG exists"},
      { LVM_ELVM_TAB_VG_REMOVE_NOT_EXISTS,
        "lvm_tab_vg_remove(): VG doesn't exist"},
      { LVM_ELVM_TAB_VG_REMOVE_UNLINK, "lvm_tab_vg_remove(): unlink"},
      { LVM_ELVM_TAB_WRITE_FCHMOD, "lvm_tab_write(): fchmod"},
      { LVM_ELVM_TAB_WRITE_OPEN, "lvm_tab_write(): open"},
      { LVM_ELVM_TAB_WRITE_WRITE, "lvm_tab_write(): write"},
      { LVM_ELVM_NOT_LOCKED, "lvm_unlock(): not locked"},
      { LVM_ELV_ACCESS, "lv_check_consistency(): LV access"},
      { LVM_ELV_ALLOCATED_LE, "vg_read_with_pv_and_lv(): allocated LE"},
      { LVM_ELV_ALLOCATION, "lv_check_consistency(): LV allocation"},
      { LVM_ELV_BADBLOCK, "lv_check_consistency(): LV badblock"},
      { LVM_ELV_CHECK_NAME_LV_NAME, "lv_check_name(): LV name"},
      { LVM_ELV_CHECK_NAME_LV_NUM, "lv_check_name(): LV number"},
      { LVM_ELV_CHECK_NAME_VG_NAME, "lv_check_name(): VG name"},
      { LVM_ELV_CHECK_STRIPE_SIZE, "lv_check_stripe_size()"},
      { LVM_ELV_CREATE_MODE_CHMOD, "lv_create_node(): chmod"},
      { LVM_ELV_CREATE_MODE_MKNOD,  "lv_create_node(): mknod"},
      { LVM_ELV_CREATE_NODE_UNLINK,  "lv_create_node(): unlink"},
      { LVM_ELV_CREATE_REMOVE_OPEN,  "lv_create_remove(): open"},
      { LVM_ELV_CURRENT_LE, "lv_check_consistency(): current LE"},
      { LVM_ELV_EXTEND_REDUCE_OPEN, "lv_extend_reduce(): open"},
      { LVM_ELV_LE_REMAP_OPEN, "lv_le_remap(): open"},
      { LVM_ELV_LVNAME, "lv_check_consistency(): LV name"},
      { LVM_ELV_MIRROR_COPIES, "lv_check_consistency(): LV mirror copies"},
      { LVM_ELV_NUMBER, "lv_check_consistency(): LV number"},
      { LVM_ELV_OPEN, "lv_check_consistency(): LV # open"},
      { LVM_ELV_READ_ALL_LV_OF_VG_LSEEK, "lv_read_all_lv_of_vg(): lseek"},
      { LVM_ELV_READ_ALL_LV_OF_VG_MALLOC, "lv_read_all_lv_of_vg(): malloc"},
      { LVM_ELV_READ_ALL_LV_OF_VG_NL, "lv_read_all_lv_of_vg(): number of LV"},
      { LVM_ELV_READ_ALL_LV_OF_VG_OPEN, "lv_read_all_lv_of_vg(): open"},
      { LVM_ELV_READ_ALL_LV_OF_VG_READ, "lv_read_all_lv_of_vg(): read"},
      { LVM_ELV_READ_ALL_LV_OF_VG_VG_READ, "lv_read_all_lv_of_vg(): vg_read"},
      { LVM_ELV_READ_BYINDEX_LV_READ_ALL_LV_OF_VG,
        "lv_read_byindex(): lv_read_all_lv_of_vg"},
      { LVM_ELV_READ_BYINDEX_VG_READ, "lv_read_byindex(): vg_read"},
      { LVM_ELV_READ_BYINDEX_VG_NAME, "lv_read_byindex(): vg_name"},
      { LVM_ELV_READ_LV, "lv_read(): read LV"},
      { LVM_ELV_READ_LV_NAME, "lv_read(): LV name"},
      { LVM_ELV_READ_LV_READ_ALL_LV_OF_VG,
        "lv_read_all_lv_of_vg(): lv_read_all_lv_of_vg"},
      { LVM_ELV_READ_VG_READ, "lv_read(): vg_read"},
      { LVM_ELV_READ_VG_NAME, "lv_read(): VG name"},
      { LVM_ELV_RECOVERY, "lv_check_consistency(): LV recovery"},
      { LVM_ELV_RELEASE_LV_NUM, "lv_release(): LV number"},
      { LVM_ELV_SCHEDULE, "lv_check_consistency(): LV schedule"},
      { LVM_ELV_SETUP_FOR_CREATE_LVM_TAB_GET_FREE_BLK_DEV,
        "lv_setup_for_create(): lvm_tab_get_free_blk_dev"},
      { LVM_ELV_SETUP_FOR_CREATE_LV_MAX, "lv_setup_for_create(): LV maximum"},
      { LVM_ELV_SETUP_FOR_CREATE_MALLOC, "lv_setup_for_create(): malloc"},
      { LVM_ELV_SETUP_FOR_CREATE_PE, "lv_setup_for_create(): PE"},
      { LVM_ELV_SETUP_FOR_CREATE_STRIPES, "lv_setup_for_create(): stripes"},
      { LVM_ELV_SETUP_FOR_CREATE_STRIPESIZE,
        "lv_setup_for_create(): stripesize"},
      { LVM_ELV_SETUP_FOR_EXTEND_LV_INDEX, "lv_setup_for_extend(): LV index"},
      { LVM_ELV_SETUP_FOR_EXTEND_REALLOC, "lv_setup_for_extend(): realloc"},
      { LVM_ELV_SETUP_FOR_EXTEND_STRIPES, "lv_setup_for_extend(): LV index"},
      { LVM_ELV_SETUP_FOR_REDUCE_LV_INDEX, "lv_setup_for_reduce(): LV index"},
      { LVM_ELV_SETUP_FOR_REDUCE_MALLOC, "lv_setup_for_reduce(): malloc"},
      { LVM_ELV_SETUP_SNAPSHOT_EXCEPTION_TABLE_MALLOC,
        "lv_setup_snapshot_exception_table(): malloc"},
      { LVM_ELV_SHOW_CURRENT_PE_TEXT_LV_INDEX,
        "lv_show_current_pe_text(): LV index"},
      { LVM_ELV_SHOW_VG_READ_WITH_PV_AND_LV,
        "lv_show(): vg_read_with_pv_and_lv"},
      { LVM_ELV_SIZE, "lv_check_consistency(): LV size"},
      { LVM_ELV_STATUS, "lv_check_consistency(): LV status"},
      { LVM_ELV_STATUS_ALL_LV_OF_VG_MALLOC, "lv_status_all_lv_of_vg(): malloc"},
      { LVM_ELV_STATUS_BYINDEX_MALLOC, "lv_status_byindex(): malloc"},
      { LVM_ELV_STATUS_BYNAME_MALLOC, "lv_status_byname(): malloc"},
      { LVM_ELV_STATUS_INTERNAL_OPEN, "lv_status_internal(): open"},
      { LVM_ELV_STATUS_NL, "lv_status(): number of LV"},
      { LVM_ELV_STRIPES, "lv_check_consistency(): LV stripes"},
      { LVM_ELV_STRIPESIZE, "lv_check_consistency(): LV stripesize"},
      { LVM_ELV_TIMEOUT, "lv_check_consistency(): LV timeout"},
      { LVM_ELV_VGNAME, "lv_check_consistency(): VG name"},
      { LVM_ELV_WRITE_ALL_LV_OF_VG_LSEEK, "lv_write_all_lv_of_vg(): lseek"},
      { LVM_ELV_WRITE_ALL_LV_OF_VG_MALLOC, "lv_write_all_lv_of_vg(): malloc"},
      { LVM_ELV_WRITE_ALL_LV_OF_VG_OPEN, "lv_write_all_lv_of_vg(): open"},
      { LVM_ELV_WRITE_ALL_LV_OF_VG_WRITE, "lv_write_all_lv_of_vg(): write"},
      { LVM_ELV_WRITE_LSEEK, "lv_write(): lseek"},
      { LVM_ELV_WRITE_OPEN, "lv_write(): open"},
      { LVM_ELV_WRITE_WRITE, "lv_write(): write"},
      { LVM_EPE_LOCK, "pe_lock(): lock"},
      { LVM_EPV_MOVE_LV_LE_REMAP, "pv_move(): LE of LV remap"},
      { LVM_EPV_MOVE_PE_LLSEEK_IN, "pv_move_pe(): llsek input extent"},
      { LVM_EPV_MOVE_PE_LLSEEK_OUT, "pv_move_pe(): llseek output extent"},
      { LVM_EPV_MOVE_PE_LOCK, "pv_move_pe(): PE lock"},
      { LVM_EPV_MOVE_PE_LV_GET_NAME, "pv_move_pe(): lv_get_name"},
      { LVM_EPV_MOVE_PE_OPEN, "pv_move_pe(): open"},
      { LVM_EPV_MOVE_PE_OPEN_IN, "pv_move_pe(): open input PV"},
      { LVM_EPV_MOVE_PE_READ_IN, "pv_move_pe(): read input PV"},
      { LVM_EPV_MOVE_PE_UNLOCK, "pv_move_pe(): unlock"},
      { LVM_EPV_MOVE_PE_WRITE_OUT, "pv_move_pe(): writing output PE"},
      { LVM_EPV_MOVE_PV_CHANGE_DEST, "pv_move_pv(): change destination PV"},
      { LVM_EPV_MOVE_PV_CHANGE_SRC, "pv_move_pv(): change source PV"},
      { LVM_EPV_MOVE_PV_PV_WRITE_WITH_PE_DEST,
        "pv_move(): pv_write_with_pe destination"},
      { LVM_EPV_MOVE_PV_PV_WRITE_WITH_PE_SRC,
        "pv_move(): pv_write_with_pe source"},
      { LVM_EPV_CHANGE_ALL_PV_FOR_LV_OF_VG_LV_NUM,
        "pv_change_all_pv_for_lv_of_vg(): LV number"},
      { LVM_EPV_CHANGE_OPEN, "pv_change(): open"},
      { LVM_EPV_CHECK_CONSISTENCY_ALL_PV_PE,
        "pv_check_consistency_all_pv(): PE"},
      { LVM_EPV_CHECK_CONSISTENCY_LVM_ID,
        "pv_check_consistencyv(): LVM identifier"},
      { LVM_EPV_CHECK_CONSISTENCY_LV_CUR,
        "pv_check_consistencyv(): current LV"},
      { LVM_EPV_CHECK_CONSISTENCY_MAJOR,
        "pv_check_consistencyv(): major device number"},
      { LVM_EPV_CHECK_CONSISTENCY_PE_ALLOCATED,
        "pv_check_consistencyv(): allocated PE"},
      { LVM_EPV_CHECK_CONSISTENCY_PE_SIZE, "pv_check_consistencyv(): PE size"},
      { LVM_EPV_CHECK_CONSISTENCY_PE_STALE,
        "pv_check_consistencyv(): stale PE"},
      { LVM_EPV_CHECK_CONSISTENCY_PE_TOTAL,
        "pv_check_consistencyv(): total PE"},
      { LVM_EPV_CHECK_CONSISTENCY_PV_ALLOCATABLE,
        "pv_check_consistencyv(): allocatable PE"},
      { LVM_EPV_CHECK_CONSISTENCY_PV_NAME, "pv_check_consistencyv(): PV name"},
      { LVM_EPV_CHECK_CONSISTENCY_PV_SIZE, "pv_check_consistencyv(): PV size"},
      { LVM_EPV_CHECK_CONSISTENCY_PV_STATUS,
        "pv_check_consistencyv(): PV status"},
      { LVM_EPV_CHECK_CONSISTENCY_STRUCT_VERSION,
        "pv_check_consistencyv(): structure version"},
      { LVM_EPV_CHECK_CONSISTENCY_VG_NAME,
        "pv_check_consistencyv(): VG name"},
      { LVM_EPV_CHECK_NAME, "pv_check_name(): PV name"},
      { LVM_EPV_CHECK_NAME_STAT, "pv_check_name(): stat"},
      { LVM_EPV_CHECK_NUMBER_MALLOC, "pv_check_number(): malloc"},
      { LVM_EPV_CHECK_NUMBER_MAX_NUMBER, "pv_check_number(): maximum number"},
      { LVM_EPV_CHECK_NUMBER_PV_NUMBER, "pv_check_number(): PV number"},
      { LVM_EPV_CHECK_PART, "pv_check_part()"},
      { LVM_EPV_FIND_ALL_PV_PV_READ, "pv_find_all_pv_names(): pv_read"},
      { LVM_EPV_FLUSH_OPEN, "pv_flush(): open"},
      { LVM_EPV_GET_SIZE_IOCTL, "pv_get_size(): ioctl"},
      { LVM_EPV_GET_SIZE_LLSEEK, "pv_get_size(): llseek"},
      { LVM_EPV_GET_SIZE_LVM_DIR_CACHE, "pv_get_size(): lvm_dir_cache"},
      { LVM_EPV_GET_SIZE_NO_EXTENDED, "pv_get_size(): no extended partition"},
      { LVM_EPV_GET_SIZE_NO_PRIMARY, "pv_get_size(): no primary partition"},
      { LVM_EPV_GET_SIZE_OPEN, "pv_get_size(): open"},
      { LVM_EPV_GET_SIZE_PART, "pv_get_size(): partition not found"},
      { LVM_EPV_GET_SIZE_READ, "pv_get_size(): read"},
      { LVM_EPV_MOVE_PES_ALLOC_STRIPES, "pv_move_pes(): allocated stripes"},
      { LVM_EPV_MOVE_PES_NO_PES, "pv_move_pes(): no PEs"},
      { LVM_EPV_MOVE_PES_NO_SPACE, "pv_move_pes(): no space"},
      { LVM_EPV_MOVE_PES_REALLOC, "pv_move_pes(): realloc"},
      { LVM_EPV_READ_ALL_PE_OF_VG_MALLOC, "pv_read_all_pe_of_vg(): malloc"},
      { LVM_EPV_READ_ALL_PE_OF_VG_PV_NUMBER,
        "pv_read-all_pe_of_vg(): PV number"},
      { LVM_EPV_READ_ALL_PV_LVM_DIR_CACHE, "pv_read_all_pv(): lvm_dir_cache"},
      { LVM_EPV_READ_ALL_PV_MALLOC, "pv_read_all_pv(): malloc"},
      { LVM_EPV_READ_ALL_PV_OF_VG_MALLOC, "pv_read_all_pv_of_vg(): malloc"},
      { LVM_EPV_READ_ALL_PV_OF_VG_NP, "pv_read_all_pv_of_vg(): no PV"},
      { LVM_EPV_READ_ALL_PV_OF_VG_NP_SORT,
        "pv_read_all_pv_of_vg(): PVs not sorted"},
      { LVM_EPV_READ_ALL_PV_OF_VG_PV_NUMBER,
        "pv_read_all_pv_of_vg(): PV number"},
      { LVM_EPV_READ_ID_INVALID, "pv_read(): PV identifier invalid"},
      { LVM_EPV_READ_LVM_STRUCT_VERSION, "pv_read(): LVM structure version"},
      { LVM_EPV_READ_MAJOR, "pv_read(): device major number"},
      { LVM_EPV_READ_MD_DEVICE, "pv_read(): multiple device"},
      { LVM_EPV_READ_NAMELIST_LSEEK, "pv_read_namelist(): lseek"},
      { LVM_EPV_READ_NAMELIST_MALLOC, "pv_read_namelist(): malloc"},
      { LVM_EPV_READ_NAMELIST_OPEN, "pv_read_namelist(): open"},
      { LVM_EPV_READ_NAMELIST_READ, "pv_read_namelist(): read"},
      { LVM_EPV_READ_OPEN, "pv_read(): open"},
      { LVM_EPV_READ_PE_LSEEK, "pv_read_pe(): lseek"},
      { LVM_EPV_READ_PE_MALLOC, "pv_read_pe(): malloc"},
      { LVM_EPV_READ_PE_OPEN, "pv_read_pe(): open"},
      { LVM_EPV_READ_PE_READ, "pv_read_pe(): read"},
      { LVM_EPV_READ_PE_SIZE, "pv_read_pe(): PV size invalid"},
      { LVM_EPV_READ_PV_CREATE_NAME_FROM_KDEV_T,
        "pv_read(): pv_create_name_from_kdev_t"},
      { LVM_EPV_READ_PV_EXPORTED, "pv_read(): PV exported"},
      { LVM_EPV_READ_PV_FLUSH, "pv_read(): pv_flush"},
      { LVM_EPV_READ_RDEV, "pv_read(): rdev"},
      { LVM_EPV_READ_READ, "pv_read(): read"},
      { LVM_EPV_READ_STAT, "pv_read(): stat"},
      { LVM_EPV_RELEASE_PE_NO_PV, "pv_release_pe(): no PV"},
      { LVM_EPV_RELEASE_PE_REALLOC, "pv_release_pe(): realloc"},
      { LVM_EPV_SHOW_PE_TEXT_MALLOC, "pv_show_pe_text(): malloc"},
      { LVM_EPV_SHOW_PE_TEXT_REALLOC, "pv_show_pe_text(): realloc"},
      { LVM_EPV_SHOW_PE_TEXT_VG_READ_WITH_PV_AND_LV,
        "pv_show_pe_text(): vg_read_with_pv_and_lv"},
      { LVM_EPV_STATUS_ALL_PV_LVM_DIR_CACHE,
        "pv_status_all_pv(): lvm_dir_cache"},
      { LVM_EPV_STATUS_ALL_PV_OF_VG_MALLOC, "pv_status_all_pv_of_vg(): malloc"},
      { LVM_EPV_STATUS_ALL_PV_OF_VG_NP, "pv_status_all_pv_of_vg(): no PV"},
      { LVM_EPV_STATUS_OPEN, "pv_status(): open"},
      { LVM_EPV_TIME_CHECK, "pv_time_check()"},
      { LVM_EPV_WRITE_LSEEK, "pv_write(): lseek"},
      { LVM_EPV_WRITE_NAMELIST_LSEEK, "pv_write_namelist(): lseek"},
      { LVM_EPV_WRITE_NAMELIST_MALLOC, "pv_write_namelist(): malloc"},
      { LVM_EPV_WRITE_NAMELIST_OPEN, "pv_write_namelist(): open"},
      { LVM_EPV_WRITE_NAMELIST_WRITE, "pv_write_namelist(): write"},
      { LVM_EPV_WRITE_OPEN, "pv_write(): open"},
      { LVM_EPV_WRITE_PE_LSEEK, "pv_write_pe(): lseek"},
      { LVM_EPV_WRITE_PE_OPEN, "pv_write_pe(): opem"},
      { LVM_EPV_WRITE_PE_SIZE, "pv_write_pe(): "},
      { LVM_EPV_WRITE_PE_WRITE, "pv_write_pe(): write"},
      { LVM_EPV_WRITE_WRITE, "pv_write(): write"},
      { LVM_EREMOVE_RECURSIVE_MALLOC, "lvm_remouverecursive(): malloc"},
      { LVM_EREMOVE_RECURSIVE_OPENDIR, "lvm_remouverecursive(): opendir"},
      { LVM_ESIZE, "LV size error"},
      { LVM_ESYSTEM_ID_SET_UNAME, "system_id(), uname"},
      { LVM_EVG_CFGBACKUP_FILE_EXISTS, "vg_cfgbackup(): file exists"},
      { LVM_EVG_CFGBACKUP_MALLOC, "vg_cfgbackup(): malloc"},
      { LVM_EVG_CFGBACKUP_OPEN, "vg_cfgbackup(): open"},
      { LVM_EVG_CFGBACKUP_READ, "vg_cfgbackup(): read"},
      { LVM_EVG_CFGBACKUP_RENAME, "vg_cfgbackup(): rename"},
      { LVM_EVG_CFGBACKUP_TMP_FILE, "vg_cfgbackup(): tmp file"},
      { LVM_EVG_CFGBACKUP_UNLINK, "vg_cfgbackup(): unlink"},
      { LVM_EVG_CFGBACKUP_VG_CHECK_EXIST, "vg_cfgbackup(): vg_check_exist"},
      { LVM_EVG_CFGBACKUP_VG_READ_WITH_PV_AND_LV,
        "vg_cfgbackup(): vg_read_with_pv_and_lv" },
      { LVM_EVG_CFGBACKUP_WRITE, "vg_cfgbackup(): write"},
      { LVM_EVG_CFGRESTORE_FILE_EXISTS, "vg_cfgrestore(): file exists"},
      { LVM_EVG_CFGRESTORE_LV_CHECK_CONSISTENCY,
        "vg_cfgrestore(): lv_check_consistency"},
      { LVM_EVG_CFGRESTORE_MALLOC, "vg_cfgrestore(): malloc"},
      { LVM_EVG_CFGRESTORE_OPEN, "vg_cfgrestore(): open"},
      { LVM_EVG_CFGRESTORE_PV_CHECK_CONSISTENCY,
        "vg_cfgrestore(): pv_check_consistency"},
      { LVM_EVG_CFGRESTORE_READ,"vg_cfgrestore(): read"},
      { LVM_EVG_CFGRESTORE_VG_CHECK_CONSISTENCY,
        "vg_cfgrestore(): vg_check_consistency"},
      { LVM_EVG_CFGRESTORE_VG_CHECK_CONSISTENCY_WITH_PV_AND_LV,
        "vg_cfgrestore(): vg_check_consistency_with_pv_and_lv"},
      { LVM_EVG_CHECK_ACTIVE_ALL_VG_COUNT,
        "vg_check_active_all_vg(): getting count"},
      { LVM_EVG_CHECK_ACTIVE_ALL_VG_MALLOC,
        "vg_check_active_all_vg(): malloc"},
      { LVM_EVG_CHECK_ACTIVE_ALL_VG_NAMELIST,
        "vg_check_active_all_vg(): namelist"},
      { LVM_EVG_CHECK_CONSISTENCY, "vg_check_consistency()"},
      { LVM_EVG_CHECK_CONSISTENCY_LV_CUR, "vg_check_consistency(): current LV"},
      { LVM_EVG_CHECK_CONSISTENCY_PE_ALLOCATED,
        "vg_check_consistency(): allocated PE"},
      { LVM_EVG_CHECK_CONSISTENCY_PE_TOTAL,
        "vg_check_consistency(): total PE"},
      { LVM_EVG_CHECK_CONSISTENCY_PVG_TOTAL,
        "vg_check_consistency(): total PVG"},
      { LVM_EVG_CHECK_CONSISTENCY_PV_ACT,
        "vg_check_consistency(): actual PV"},
      { LVM_EVG_CHECK_CONSISTENCY_PV_CUR,
        "vg_check_consistency(): current PV"},
      { LVM_EVG_CHECK_CONSISTENCY_PE_SIZE,
        "vg_check_consistency(): PE size"},
      { LVM_EVG_CHECK_CONSISTENCY_VGDA,
        "vg_check_consistency(): VGDA"},
      { LVM_EVG_CHECK_CONSISTENCY_VG_ACCESS,
        "vg_check_consistency(): VG access"},
      { LVM_EVG_CHECK_CONSISTENCY_VG_NAME,
        "vg_check_consistency(): VG name"},
      { LVM_EVG_CHECK_CONSISTENCY_VG_STATUS,
        "vg_check_consistency(): VG status"},
      { LVM_EVG_CHECK_EXIST_PV_COUNT, "vg_check_exits(): PV count"},
      { LVM_EVG_CHECK_NAME, "vg_check_name()"},
      { LVM_EVG_CHECK_ONLINE_ALL_PV, "vg_check_online_all_pv()"},
      { LVM_EVG_CHECK_ONLINE_ALL_PV_MALLOC, "vg_check_online_all_pv(): malloc"},
      { LVM_EVG_CHECK_PE_SIZE, "vg_check_pe_size()"},
      { LVM_EVG_CREATE_DIR_AND_GROUP_CHMOD_DIR,
        "vg_create_dir_and_group(): chmod directory"},
      { LVM_EVG_CREATE_DIR_AND_GROUP_CHMOD_GROUP,
        "vg_create_dir_and_group(): chmod group file"},
      { LVM_EVG_CREATE_DIR_AND_GROUP_MKDIR,
        "vg_create_dir_and_group(): mkdir"},
      { LVM_EVG_CREATE_DIR_AND_GROUP_MKNOD,
        "vg_create_dir_and_group(): mknod"},
      { LVM_EVG_CREATE_REMOVE_OPEN, "vg_create_remove(): open"},
      { LVM_EVG_EXTEND_REDUCE_OPEN, "vg_extend_reduce(): open"},
      { LVM_EVG_READ_LSEEK, "vg_read(): lseek"},
      { LVM_EVG_READ_LVM_STRUCT_VERSION,
        "vg_read(): LVM structure version nit supported/invalid"},
      { LVM_EVG_READ_OPEN, "vg_read(): open"},
      { LVM_EVG_READ_PV, "vg_read(): PV"},
      { LVM_EVG_READ_READ, "vg_read(): read"},
      { LVM_EVG_READ_VG_EXPORTED, "vg_read(): VG exported"},
      { LVM_EVG_READ_WITH_PV_AND_LV_LV_ALLOCATED_LE,
        "vg_read_with_pv_and_lv(): allocated LE of LV"},
      { LVM_EVG_READ_WITH_PV_AND_LV_MALLOC,
        "vg_read_with_pv_and_lv(): malloc"},
      { LVM_EVG_READ_WITH_PV_AND_LV_PV_CUR,
        "vg_read_with_pv_and_lv(): current PV"},
      { LVM_EVG_SETUP_FOR_CREATE_MALLOC,
        "vg_setup_for_create(): malloc"},
      { LVM_EVG_SETUP_FOR_CREATE_PV_SIZE,
        "vg_setup_for_create(): PV size"},
      { LVM_EVG_SETUP_FOR_CREATE_VG_NUMBER,
        "vg_setup_for_create(): VG number"},
      { LVM_EVG_SETUP_FOR_EXTEND_MALLOC,
        "vg_setup_for_extend(): malloc"},
      { LVM_EVG_SETUP_FOR_EXTEND_MAX_PV,
        "vg_setup_for_extend(): PV maximum"},
      { LVM_EVG_SETUP_FOR_EXTEND_NO_PV,
        "vg_setup_for_extend(): no PV"},
      { LVM_EVG_SETUP_FOR_EXTEND_PV_ALREADY,
        "vg_setup_for_extend(): PV already recognized"},
      { LVM_EVG_SETUP_FOR_EXTEND_PV_CHECK_NAME,
        "vg_setup_for_extend(): pv_check_name"},
      { LVM_EVG_SETUP_FOR_EXTEND_PV_CHECK_NEW,
        "vg_setup_for_extend(): pv_check_new"},
      { LVM_EVG_SETUP_FOR_EXTEND_PV_GET_SIZE,
        "vg_setup_for_extend(): pv_get_size"},
      { LVM_EVG_SETUP_FOR_EXTEND_PV_SIZE,
        "vg_setup_for_extend(): PV size"},
      { LVM_EVG_SETUP_FOR_EXTEND_PV_SIZE_REL,
        "vg_setup_for_extend(): PV size too small for PE size"},

      { LVM_EVG_SETUP_FOR_MERGE_BLK_DEV, "vg_setup_for_merge(): block device"},
      { LVM_EVG_SETUP_FOR_MERGE_LV_MAX, "vg_setup_for_merge(): LV maximum"},
      { LVM_EVG_SETUP_FOR_MERGE_PE_SIZE, "vg_setup_for_merge(): PE size"},
      { LVM_EVG_SETUP_FOR_MERGE_PV_MAX, "vg_setup_for_merge(): PV maximum"},
      { LVM_EVG_SETUP_FOR_MERGE_VG_CHECK_CONSISTENCY_WITH_PV_AND_LV,
        "vg_setup_for_merge(): vg_check_consistency_with_pv_and_lv"},
      { LVM_EVG_SETUP_FOR_REDUCE_LAST_PV, "vg_setup_for_reduce(): last PV"},
      { LVM_EVG_SETUP_FOR_REDUCE_LAST_PV_NOT_IN_VG,
        "vg_setup_for_reduce(): PV is not in VG"},
      { LVM_EVG_SETUP_FOR_REDUCE_LV, "vg_setup_for_reduce(): LV exists on PV"},
      { LVM_EVG_SETUP_FOR_REDUCE_NO_PV_TO_REDUCE,
        "vg_setup_for_reduce(): no PV to reduce"},
      { LVM_EVG_SETUP_FOR_REDUCE_PV_INVALID,
        "vg_setup_for_reduce(): PV invalid"},
      { LVM_EVG_SETUP_FOR_REDUCE_REALLOC, "vg_setup_for_reduce(): realloc"},
      { LVM_EVG_SETUP_FOR_SPLIT_LV_ON_PV, "vg_setup_for_split(): LV is on PV"},
      { LVM_EVG_SETUP_FOR_SPLIT_MALLOC, "vg_setup_for_split(): malloc"},
      { LVM_EVG_SETUP_FOR_SPLIT_PV, "vg_setup_for_split(): PV invalid"},
      { LVM_EVG_SETUP_FOR_SPLIT_PV_COUNT, "vg_setup_for_split(): PV count"},
      { LVM_EVG_SETUP_FOR_SPLIT_VG_NUMBER, "vg_setup_for_split(): VG number"},

      { LVM_EVG_SET_CLEAR_EXTENDABLE_OPEN, "vg_set_clear_extendable(): open"},
      { LVM_EVG_STATUS_GET_COUNT_OPEN, "vg_status_get_count(): open"},
      { LVM_EVG_STATUS_GET_NAMELIST_OPEN, "vg_status_get_namelist(): open"},
      { LVM_EVG_STATUS_MALLOC, "vg_status(): malloc"},
      { LVM_EVG_STATUS_OPEN, "vg_status(): open"},
      { LVM_EVG_WRITE_LSEEK, "vg_write(): lseek"},
      { LVM_EVG_WRITE_OPEN, "vg_write(): open"},
      { LVM_EVG_WRITE_WRITE, "vg_write(): write"},
      { 0, NULL}
   };


#ifdef DEBUG
   debug_enter ( "lvm_error -- CALLED with: %d\n", error);
#endif

   for ( c = 0; lvm_errors[c].error != 0; c++) {
      if ( lvm_errors[c].error == -error) break;
   }

   if ( lvm_errors[c].errstr == NULL) {
      sprintf ( buffer, "%d%c", error, 0);
      ret = buffer;
   } else ret = lvm_errors[c].errstr;

#ifdef DEBUG
   debug_enter ( "lvm_error -- LEAVING with: \"%s\"\n", ret);
#endif

   return ret;
}
