/*
 * tools/lib/basename.c
 *
 * Copyright (C) 1997 - 2000  Heinz Mauelshagen, Germany
 *
 * March 1997
 * January 2000
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 * Changelog
 *
 *    31/01/2000 - use debug_enter()/debug_leave()
 *
 */

#include <liblvm.h>

#if __GLIBC__ < 2
char *basename(char *path)
{
	char *base, *slash, *ret;

#ifdef DEBUG
	debug_enter ( "basename -- CALLED with path: \"%s\"\n", path);
#endif

	if (path == NULL) ret = NULL;
	else
	{
		base = slash = path;
		while (*base != 0) {
			if (*base == '/')
				slash = base;
			base++;
		}
	}

	if (slash == path)
		ret = path;
	else
		ret = ++slash;

#ifdef DEBUG
	debug_leave ( "basename -- LEAVING with ret: \"%s\"\n", ret);
#endif
	return ret;
}
#endif
