/*
 * Copyright (C)  1998, 1999  Heinz Mauelshagen, Germany
 *
 * February 2000
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#include <liblvm.h>


int lv_setup_snapshot_exception_table ( vg_t *vg_core,
                                        char *lv_name,
                                        vg_t* vg_disk,
                                        int l_new,
                                        int chunk_size) {
   int div, e, end, l_org, ret = 0;
   ulong size;
   char *dummy = NULL;
   lv_t *lv = NULL;

#ifdef DEBUG
   debug_enter ( "lv_setup_snapshot_exception_table -- CALLED\n");
#endif

   if ( vg_core == NULL ||
        vg_check_consistency ( vg_core) < 0 ||
        lv_name == NULL ||
        lv_check_name ( lv_name) < 0 ||
        vg_disk == NULL ||
        vg_check_consistency_with_pv_and_lv ( vg_disk) < 0 ||
        vg_disk->lv[l_new] == NULL) ret = -LVM_EPARAM;
   else {
      l_org = lv_get_index_by_name ( vg_core, lv_name);
      lv = vg_disk->lv[l_new];
      lv->lv_access |= LV_SNAPSHOT;
      lv->lv_snapshot_org = NULL;
      lv->lv_snapshot_minor = MINOR ( vg_core->lv[l_org]->lv_dev);
      vg_disk->lv[l_org]->lv_access |= LV_SNAPSHOT_ORG;
      vg_disk->lv[l_org]->lv_snapshot_minor = 0;
   
      /* remap chunk size */
      lv->lv_chunk_size = chunk_size * 2;
      if ( chunk_size == LVM_SNAPSHOT_DEF_CHUNK) {
          printf ( "%s -- INFO: using default snapshot chunk size of %s\n",
                   cmd,
                   ( dummy = lvm_show_size ( chunk_size, SHORT)));
          free ( dummy); dummy = NULL;
      }
      size = lv->lv_allocated_le * vg_disk->pe_size;
      end = size / lv->lv_chunk_size;
      size = end * sizeof ( lv_block_exception_t);
   
      if ( ( lv->lv_block_exception = malloc ( size)) == NULL) {
         fprintf ( stderr, "%s -- ERROR: malloc at line %d\n\n", cmd, __LINE__);
         ret = LVM_ELV_SETUP_SNAPSHOT_EXCEPTION_TABLE_MALLOC;
      } else {
         memset ( lv->lv_block_exception, 0, size);
         div = vg_disk->pe_size / lv->lv_chunk_size;
   
         for ( e = 0; e < end; e++) {
            int index = e / div;
   
            lv->lv_block_exception[e].rdev_new =
               lv->lv_current_pe[index].dev;
            lv->lv_block_exception[e].rsector_new =
               lv->lv_current_pe[index].pe +
               ( e % div) * lv->lv_chunk_size;
         }
         lv->lv_remap_end = end;
         lv->lv_remap_ptr = 0;
      }
   }

#ifdef DEBUG
   debug_leave ( "lv_setup_snapshot_exception_table -- LEAVING with ret: %d\n",
                 ret);
#endif
   return ret;
}
