#include "../lib/bug.h"


main()
{
  /* write 8 blocks then read them back */
  int i;
  char buf[512];
  int j;
  bug_dskio diskio;

  /* write 8 blocks out */
  for (i = 0; i < 8; i++) {
    /* create a buffer with something unique in it */
    for (j = 0; j < sizeof(buf); j++)
      buf[j] = (0x1 << i);
    /* create an ioctl buf */
    diskio.ctrl_lun = 0;
    diskio.dev_lun = 0;
    diskio.status = 0;
    diskio.pbuffer = buf;
    diskio.blk_num = i;
    diskio.blk_cnt = 1;
    diskio.flag = 0;
    diskio.addr_mod = 0;
    /* log it */
    write_string("write block[");
    write_int(i);
    write_string("]");
    write_line();
    /* write the buffer out */
    bug_diskwr(&diskio);
  }
  
  /* read 8 blocks back */
  for (i = 7; i >= 0; i--) {
    /* log the read */
    write_string("read block[");
    write_int(i);
    write_string("]");
    /* create an ioctl buf */
    diskio.ctrl_lun = 0;
    diskio.dev_lun = 0;
    diskio.status = 0;
    diskio.pbuffer = buf;
    diskio.blk_num = i;
    diskio.blk_cnt = 1;
    diskio.flag = 0;
    diskio.addr_mod = 0;
    /* read the buffer in */
    bug_diskrd(&diskio);
    /* verify that the block is correct */
    for (j = 0; j < sizeof(buf); j++) {
      if (buf[j] != (0x1 << i)) {
	write_string(".buf[");
	write_int(j);
	write_string("] does not match");
	write_line();
	exit(1);
      }
    }
    write_string(" ok");
    write_line();
  }
  exit (0);
}
