/*	$NetBSD$ */
/*
 * Copyright (c) 1995 Dale Rahn.
 * All rights reserved.
 *   
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *   This product includes software developed by Dale Rahn.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */  
/*
 * bug routines -- assumes that the necessary sections of memory
 * are preserved.
 */
#include "bug.h"

#define _INCHR		"0x00"
#define _INSTAT		"0x01"
#define _INLN		"0x02"
#define _READSTR	"0x03"
#define _READLN		"0x04"
#define _OUTCHR		"0x20"
#define _OUTSTR		"0x21"
#define _OUTLN		"0x22"
#define _DSKRD		"0x10"
#define _DSKWR		"0x11"
#define _DSKCFIG	"0x12"
#define _DSKFMT		"0x14"
#define _DSKCTRL	"0x15"
#define _WRITE		"0x23"
#define _WRITELN	"0x24"
#define _DELAY		"0x43"
#define _RTC_RD		"0x53"
#define _RETURN		"0x63"
#define _BRD_ID		"0x70"

/* BUG  -  tty routines */

#define BUG_CALL(x)	\
	asm volatile ("addi 10,0," x); \
	asm volatile ("sc");

char bug_inchr()
{
	register char a;
	BUG_CALL(_INCHR);
	asm volatile ("or %0,0,3" :  "=r" (a));
	return a;
}

/* returns 0 if no characters ready to read */
int bug_instat()
{
	short ret;
	BUG_CALL(_INSTAT);
	asm volatile ("or %0,0,3" :  "=r" (ret));
	return (!(ret & 0x4));
	
}

void bug_outchr(char a)
{
	asm volatile ("or 3, 0, %0" :  :"r" (a));
	BUG_CALL(_OUTCHR);
	return;
}

void bug_outstr(char *pstrb, char *pstre)
{
	asm volatile ("or 3,0,%0": : "r" (pstrb) );
	asm volatile ("or 4,0,%0": : "r" (pstre) );
	BUG_CALL(_OUTSTR);
	return;
}

void bug_outln(char *pstrb, char *pstre)
{
	asm volatile ("or 3,0,%0": : "r" (pstrb) );
	asm volatile ("or 4,0,%0": : "r" (pstre) );
	BUG_CALL(_OUTLN);
	return;
}

/* BUG - disk routines */

/* returns 0: success, nonzero: error */
int bug_diskrd(bug_dskio *arg)
{
	int ret;
	asm volatile ("or 3,0,%0": : "r" (arg) );
	BUG_CALL(_DSKRD);
	asm volatile ("or %0,0,3" :  "=r" (ret));
	return (!(ret & 0x4));
}
/* returns 0: success, nonzero: error */
int bug_diskwr(bug_dskio *arg)
{
	int ret;
	asm volatile ("or 3,0,%0": : "r" (arg) );
	BUG_CALL(_DSKWR);
	asm volatile ("or %0,0,3" :  "=r" (ret));
	return (!(ret & 0x4));
}
#ifdef NOTYET
bug_diskcfig()
{
	
}
bug_diskfmt(){}
bug_diskctrl(){}
#endif

/* BUG - timing routine */

void bug_delay(int delay_msec)
{
	asm volatile ("or 3,0,%0": : "r" (delay_msec) );
	BUG_CALL(_DELAY);
	return ;
}

/* BUG - return to bug routine */

void bug_return()
{
	BUG_CALL(_RETURN);
	/*NOTREACHED*/
}

/* BUG - query board routines */

struct bug_brdid *bug_brdid()
{
	struct bug_brdid *pbrd_id;
	BUG_CALL(_BRD_ID);
	asm volatile ("or %0,0,3": "=r" (pbrd_id):);
	return pbrd_id;
}
void bug_rtc_rd(struct bug_time *ptime)
{
	asm volatile ("or 3,0,%0": : "r" (ptime));
	BUG_CALL(_RTC_RD);
	return;
}
