/* Print out the current value of the NVRAM */


void
catch()
{
  write_string("Caught interrupt\n");
  write_line();
  exit(1);
}

int
com_read_ready(char *com)
{
  return ((com[5] & 0x1) == 0x1);
}

int
com_carrier(char *com)
{
  return ((com[6] & 0x80) == 0x80);
}

int
readc(char *com)
{
  while (1) {
    if (com_read_ready(com)) {
      unsigned char c = (unsigned char)com[0];
      if (!com_carrier(com))
	return -1;
      else
	return c;
    }
    if (!com_carrier(com))
      return -1;
  }
}

void
writec(char *com, char c)
{
  while ((com[5] & 0x60) != 0x60);
  com[0] = c;
}


int
main(int argc, char **argv)
{
  char *com;
  
  /* find our serial ports */
  if (argc != 2) {
    write_string("Usage: cat <com-addr>");
    write_line();
    exit (1);
  }
  com = (char*)strtoul(argv[1], 0, 0);

  while (1) {
    int ch = readc(com);
    if (ch == -1) break;
    writec(com, ch);
  }

  exit(0);
}
