#include "../lib/of1275.h"


main()
{
  /* write 8 blocks then read them back */
  int i;
  char buf[512];
  int j;
  int disk_ihandle;
  int status;

  /* find the chosen disk */
  disk_ihandle = of_find_integer_property("/chosen", "disk0");

  /* write 8 blocks out */
  for (i = 0; i < 8; i++) {
    /* create a buffer with something unique in it */
    for (j = 0; j < sizeof(buf); j++)
      buf[j] = (0x1 << i);
    /* log it */
    write_string("write block[");
    write_int(i);
    write_string("]");
    /* position the disk */
    of1275_seek(disk_ihandle, 0, sizeof(buf) * i, &status);
    if (status < 0) {
      write_string(" seek failed");
      write_line();
      exit(1);
    }
    /* write the block */
    of1275_write(disk_ihandle, buf, sizeof(buf), &status);
    if (status != sizeof(buf)) {
      write_string(" write failed");
      write_line();
      exit(1);
    }
    write_line();
  }
  
  /* read 8 blocks back */
  for (i = 7; i >= 0; i--) {
    /* log it */
    write_string("read block[");
    write_int(i);
    write_string("]");
    /* position the disk */
    of1275_seek(disk_ihandle, 0, sizeof(buf) * i, &status);
    if (status < 0) {
      write_string(" seek failed");
      write_line();
      exit(1);
    }
    /* read the block */
    of1275_read(disk_ihandle, buf, sizeof(buf), &status);
    if (status != sizeof(buf)) {
      write_string(" read failed");
      write_line();
      exit(1);
    }
    /* verify that the block is correct */
    for (j = 0; j < sizeof(buf); j++) {
      if (buf[j] != (0x1 << i)) {
	write_string(".buf[");
	write_int(j);
	write_string("] does not match");
	write_line();
	exit(1);
      }
    }
    write_string(" ok");
    write_line();
  }
  exit (0);
}
