/* erase the entire eeprom */

#include "eeprom.h"

int
main()
{
  int i;
  eeprom_args eeprom;
  parse_eeprom_args(&eeprom);

  /* write the erase eeprom sequence */
  erase_eeprom(&eeprom);

  /* wait for it to finish */
  for (i = 0; i < eeprom.erase_delay; i++) {
    if ((eeprom.memory[0] & 0x80) == 0x80) {
      int j;
      for (j = 0; j < (eeprom.nr_sectors * eeprom.sector_size); j += sizeof(int)) {
	int memory = *(int*)(eeprom.memory + j);
	if (memory != -1) {
	  write_string("byte 0x");
	  write_hex(j);
	  write_string(" not 0xff");
	  write_line();
	  exit(1);
	}
      }
      write_string("Chip erased after ");
      write_int(i);
      write_string(" iterations");
      write_line();
      exit(0);
    }
  }

  write_string("erase-chip timed out");
  write_line();
  exit(1);
}
