#include "opic.h"
#include "../lib/of1275.h"

void
opic_parse_args(opic_descriptor *opic,
		int verbose)
{
  char *chp;
  int i;

  /* find the boot args */
  char bootargs[128];
  of_find_string_property("/chosen", "bootargs", bootargs, sizeof(bootargs));
  if (verbose) {
    write_string("args: ");
    write_string(bootargs);
    write_line();
  }

  /* get the path */
  for (i = 0; bootargs[i] != '\0' && bootargs[i] != ' '; i++)
    opic->path[i] = bootargs[i];
  opic->path[i] = '\0';
    
  /* get the opic address - registers + input and output ports */
  chp = &bootargs[i];
  opic->address = (void*)strtoul(chp, &chp, 0);
  opic->input = (void*)strtoul(chp, &chp, 0);
  opic->nr_inputs = strtoul(chp, &chp, 0);
  opic->output = (void*)strtoul(chp, &chp, 0);
  opic->nr_outputs = strtoul(chp, &chp, 0);
  opic->init = (void*)strtoul(chp, &chp, 0);
  opic->nr_inits = strtoul(chp, &chp, 0);

  /* OPIC offsets */
  opic->global = opic->address + 0x01000;
  opic->per_processor = opic->address + 0x20000;
  opic->interrupt_source_configuration = opic->address + 0x10000;

  if (verbose) {
    write_string("  global: 0x");
    write_hex(opic->global);
    write_line();
    write_string("  per-processor: 0x");
    write_hex(opic->per_processor);
    write_line();
    write_string("  interrupt-source-configuration: 0x");
    write_hex(opic->interrupt_source_configuration);
    write_line();
    
    write_string("  glue-input: 0x");
    write_hex(opic->input);
    write_string(" (");
    write_int(opic->nr_inputs);
    write_string(")");
    write_line();
    
    write_string("  glue-output: 0x");
    write_hex(opic->output);
    write_string(" (");
    write_int(opic->nr_outputs);
    write_string(")");
    write_line();
    
    
    write_string("  glue-init: 0x");
    write_hex(opic->init);
    write_string(" (");
    write_int(opic->nr_inits);
    write_string(")");
    write_line();
    
  }

}
