/* java.c -- set LD_LIBRARY_PATH, LD_PRELOAD and exec gij
   Copyright (C) 2005  Red Hat

This file is part of java-gcj-compat.

java-gcj-compat is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

java-gcj-compat is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with java-gcj-compat; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

int
main (int argc, char* argv[])
{
  int error_code = 0;
  char *libpath = NULL;
  char *preload = NULL;
  char *newpreload = NULL;
  char *newpath = NULL;
  int newlen = 0;

  preload = getenv ("LD_PRELOAD");
  
  if (preload && preload[0] != '\0')
    {
      newlen += strlen (preload);
      // for the separating ' '
      newlen += 1;
    }

  newlen += sizeof (JAVA_HOME) - 1;
  newlen += sizeof ("/lib//pr13212.so") - 1;
  newlen += sizeof (ARCH) - 1;

  newpreload = (char *) malloc (newlen + 1);

  if (newpreload != NULL)
    {
      if (preload && preload[0] != '\0')
        snprintf (newpreload, newlen + 1,
                  "%s/lib/%s/pr13212.so %s", JAVA_HOME, ARCH, preload);
      else
        snprintf (newpreload, newlen + 1, "%s/lib/%s/pr13212.so", JAVA_HOME, ARCH);
    }

  setenv ("LD_PRELOAD", newpreload, 1);

  free (newpreload);


  newlen = 0;

  libpath = getenv ("LD_LIBRARY_PATH");

  if (libpath && libpath[0] != '\0')
    {
      newlen += strlen (libpath);
      // for the separating ':'
      newlen += 1;
    }

  newlen += sizeof (JAVA_HOME) - 1;
  newlen += sizeof ("/lib/") - 1;
  newlen += sizeof (ARCH) - 1;

  newpath = (char *) malloc (newlen + 1);

  if (newpath != NULL)
    {
      if (libpath && libpath[0] != '\0')
        snprintf (newpath, newlen + 1,
                  "%s%s%s%s%s", JAVA_HOME, "/lib/", ARCH, ":", libpath);
      else
        snprintf (newpath, newlen + 1, "%s%s%s", JAVA_HOME, "/lib/", ARCH);
    }

  setenv ("LD_LIBRARY_PATH", newpath, 1);

  free (newpath);

  error_code = execv (GCJ_BIN_DIR "/gij", argv);

  fprintf (stderr, "error spawning gij\n");

  return error_code;
}
